/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow.conditions;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Subquery;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.jpa.entities.UserGroupMembershipEntity;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.workflow.WorkflowConditionProvider;
import org.keycloak.models.workflow.WorkflowExecutionContext;
import org.keycloak.models.workflow.WorkflowInvalidStateException;
import org.keycloak.utils.StringUtil;

public class GroupMembershipWorkflowConditionProvider
implements WorkflowConditionProvider {
    private final String expectedGroup;
    private final KeycloakSession session;

    public GroupMembershipWorkflowConditionProvider(KeycloakSession session, String expectedGroup) {
        this.session = session;
        this.expectedGroup = expectedGroup;
    }

    public boolean evaluate(WorkflowExecutionContext context) {
        this.validate();
        RealmModel realm = this.session.getContext().getRealm();
        UserModel user = this.session.users().getUserById(realm, context.getResourceId());
        if (user == null) {
            return false;
        }
        GroupModel group = KeycloakModelUtils.findGroupByPath((KeycloakSession)this.session, (RealmModel)realm, (String)this.expectedGroup);
        return user.isMemberOf(group);
    }

    public Predicate toPredicate(CriteriaBuilder cb, CriteriaQuery<String> query, Root<?> path) {
        this.validate();
        GroupModel group = KeycloakModelUtils.findGroupByPath((KeycloakSession)this.session, (RealmModel)this.session.getContext().getRealm(), (String)this.expectedGroup);
        if (group == null) {
            return cb.disjunction();
        }
        Subquery subquery = query.subquery(Integer.class);
        Root from = subquery.from(UserGroupMembershipEntity.class);
        subquery.select(cb.literal((Object)1));
        subquery.where((Expression)cb.and((Expression)cb.equal((Expression)from.get("user").get("id"), (Expression)path.get("id")), (Expression)cb.equal((Expression)from.get("groupId"), (Object)group.getId())));
        return cb.exists(subquery);
    }

    public void validate() {
        if (StringUtil.isBlank((String)this.expectedGroup)) {
            throw new WorkflowInvalidStateException("Expected group path not set.");
        }
        if (KeycloakModelUtils.findGroupByPath((KeycloakSession)this.session, (RealmModel)this.session.getContext().getRealm(), (String)this.expectedGroup) == null) {
            throw new WorkflowInvalidStateException(String.format("Group with name %s does not exist.", this.expectedGroup));
        }
    }

    public void close() {
    }
}

