/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow;

import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserManager;
import org.keycloak.models.UserModel;
import org.keycloak.models.cache.UserCache;
import org.keycloak.models.workflow.WorkflowExecutionContext;
import org.keycloak.models.workflow.WorkflowStepProvider;
import org.keycloak.storage.UserStoragePrivateUtil;
import org.keycloak.storage.UserStorageUtil;

public class DeleteUserStepProvider
implements WorkflowStepProvider {
    public static final String PROPAGATE_TO_SP = "propagate-to-provider";
    private final KeycloakSession session;
    private final ComponentModel stepModel;
    private final Logger log = Logger.getLogger(DeleteUserStepProvider.class);

    public DeleteUserStepProvider(KeycloakSession session, ComponentModel model) {
        this.session = session;
        this.stepModel = model;
    }

    public void close() {
    }

    public void run(WorkflowExecutionContext context) {
        RealmModel realm = this.session.getContext().getRealm();
        UserModel user = this.session.users().getUserById(realm, context.getResourceId());
        if (user == null) {
            return;
        }
        UserManager userManager = new UserManager(this.session);
        if (!user.isFederated() || this.stepModel.get(PROPAGATE_TO_SP, false)) {
            this.log.debugv("Deleting user {0} ({1})", (Object)user.getUsername(), (Object)user.getId());
            userManager.removeUser(realm, user);
            return;
        }
        userManager.removeUser(realm, user, UserStoragePrivateUtil.userLocalStorage((KeycloakSession)this.session));
        this.log.debugv("Deleting federated user {0} ({1}) from local storage only", (Object)user.getUsername(), (Object)user.getId());
        UserCache userCache = UserStorageUtil.userCache((KeycloakSession)this.session);
        if (userCache != null) {
            userCache.evict(realm, user);
        }
    }

    public String getNotificationMessage() {
        return "accountDeleteNotificationBody";
    }

    public String getNotificationSubject() {
        return "accountDeleteNotificationSubject";
    }
}

