/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.util.Objects;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;

public class SqmCollectionSize
extends AbstractSqmExpression<Integer> {
    private final SqmPath<?> pluralPath;

    public SqmCollectionSize(SqmPath<?> pluralPath, NodeBuilder nodeBuilder) {
        this(pluralPath, nodeBuilder.getIntegerType(), nodeBuilder);
    }

    public SqmCollectionSize(SqmPath<?> pluralPath, SqmBindableType<Integer> sizeType, NodeBuilder nodeBuilder) {
        super(sizeType, nodeBuilder);
        this.pluralPath = pluralPath;
    }

    @Override
    public SqmCollectionSize copy(SqmCopyContext context) {
        SqmCollectionSize existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmCollectionSize expression = context.registerCopy(this, new SqmCollectionSize((SqmPath<?>)this.pluralPath.copy(context), this.getNodeType(), this.nodeBuilder()));
        this.copyTo(expression, context);
        return expression;
    }

    public SqmPath<?> getPluralPath() {
        return this.pluralPath;
    }

    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitPluralAttributeSizeFunction(this);
    }

    @Override
    public String asLoggableText() {
        return "SIZE(" + this.pluralPath.asLoggableText() + ")";
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        hql.append("size(");
        this.pluralPath.appendHqlString(hql, context);
        hql.append(')');
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof SqmCollectionSize)) return false;
        SqmCollectionSize that = (SqmCollectionSize)object;
        if (!Objects.equals(this.pluralPath, that.pluralPath)) return false;
        return true;
    }

    public int hashCode() {
        return this.pluralPath.hashCode();
    }
}

