/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl.constant;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.constant.ConstImpl;
import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.util.Optional;

public final class DoubleConst
extends ConstImpl {
    private final double value;

    public DoubleConst(double value) {
        super(ConstantDescs.CD_double);
        this.value = value;
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block) {
        int asInt = (int)this.value;
        long asLong = (long)this.value;
        if ((long)asInt == asLong && this.value == (double)asLong) {
            switch (asInt) {
                case -5: {
                    cb.iconst_5();
                    cb.ineg();
                    cb.i2d();
                    break;
                }
                case -4: {
                    cb.iconst_4();
                    cb.ineg();
                    cb.i2d();
                    break;
                }
                case -3: {
                    cb.iconst_3();
                    cb.ineg();
                    cb.i2d();
                    break;
                }
                case -2: {
                    cb.iconst_2();
                    cb.ineg();
                    cb.i2d();
                    break;
                }
                case -1: {
                    cb.iconst_m1();
                    cb.i2d();
                    break;
                }
                case 0: {
                    cb.dconst_0();
                    break;
                }
                case 1: {
                    cb.dconst_1();
                    break;
                }
                case 2: {
                    cb.iconst_2();
                    cb.i2d();
                    break;
                }
                case 3: {
                    cb.iconst_3();
                    cb.i2d();
                    break;
                }
                case 4: {
                    cb.iconst_4();
                    cb.i2d();
                    break;
                }
                case 5: {
                    cb.iconst_5();
                    cb.i2d();
                    break;
                }
                default: {
                    if (-128 <= asInt && asInt <= 127) {
                        cb.bipush(asInt);
                        cb.i2d();
                        break;
                    }
                    if (Short.MIN_VALUE <= asInt && asInt <= Short.MAX_VALUE) {
                        cb.sipush(asInt);
                        cb.i2d();
                        break;
                    }
                    cb.ldc((ConstantDesc)Double.valueOf(this.value));
                    break;
                }
            }
        } else {
            cb.ldc((ConstantDesc)Double.valueOf(this.value));
        }
    }

    @Override
    public boolean isZero() {
        return this.value == 0.0;
    }

    @Override
    public boolean isNonZero() {
        return this.value != 0.0;
    }

    @Override
    public boolean equals(ConstImpl obj) {
        DoubleConst other;
        return obj instanceof DoubleConst && this.equals(other = (DoubleConst)obj);
    }

    public boolean equals(DoubleConst other) {
        return this == other || other != null && Double.doubleToRawLongBits(this.value) == Double.doubleToRawLongBits(other.value);
    }

    @Override
    public int hashCode() {
        return Long.hashCode(Double.doubleToRawLongBits(this.value));
    }

    @Override
    public Double desc() {
        return this.value;
    }

    public Optional<Double> describeConstable() {
        return Optional.of(this.value);
    }

    @Override
    public StringBuilder toShortString(StringBuilder b) {
        return b.append(this.value).append(" (").append(Double.toHexString(this.value)).append(')');
    }
}

