/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crl.infinispan;

import java.security.GeneralSecurityException;
import java.security.cert.X509CRL;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.crl.CrlStorageProvider;
import org.keycloak.crl.infinispan.X509CRLEntry;

public class InfinispanCrlStorageProvider
implements CrlStorageProvider {
    private static final Logger log = Logger.getLogger(InfinispanCrlStorageProvider.class);
    private final SharedData data;

    public InfinispanCrlStorageProvider(SharedData data) {
        this.data = data;
    }

    public X509CRL get(String key, Callable<X509CRL> loader) throws GeneralSecurityException {
        X509CRLEntry crlEntry = (X509CRLEntry)this.data.cache().get((Object)key);
        long currentTime = Time.currentTimeMillis();
        if (crlEntry != null && (crlEntry.crl().getNextUpdate() == null || crlEntry.crl().getNextUpdate().compareTo(new Date(currentTime)) > 0)) {
            log.debugf("returning CRL '%s' from cache because it's cached OK", (Object)key);
            return crlEntry.crl();
        }
        return this.reloadCrl(key, loader, currentTime, crlEntry);
    }

    public boolean refreshCache(String key, Callable<X509CRL> loader) throws GeneralSecurityException {
        X509CRLEntry entry = (X509CRLEntry)this.data.cache().get((Object)key);
        X509CRL crl = this.reloadCrl(key, loader, Time.currentTimeMillis(), entry);
        return crl != null && (entry == null || entry.crl() != crl);
    }

    public void close() {
    }

    private X509CRL reloadCrl(String key, Callable<X509CRL> loader, long currentTime, X509CRLEntry crlEntry) {
        if (crlEntry != null && currentTime < crlEntry.lastRequestTime() + this.data.minTimeBetweenRequests()) {
            log.debugf("Avoiding loading crl with key '%s' again, last refreshed time %d", (Object)key, (Object)crlEntry.lastRequestTime());
            return crlEntry.crl();
        }
        FutureTask<X509CRL> task = new FutureTask<X509CRL>(() -> this.loadCrl(key, loader, currentTime));
        FutureTask<X509CRL> existing = this.data.tasksInProgress().putIfAbsent(key, task);
        if (existing == null) {
            log.debugf("Reloading crl for model key '%s'.", (Object)key);
            task.run();
        } else {
            task = existing;
        }
        try {
            X509CRL x509CRL = task.get();
            return x509CRL;
        }
        catch (ExecutionException ee) {
            throw new RuntimeException("Error when loading crl " + key + " : " + ee.getMessage(), ee);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Error. Interrupted when loading crl " + key, ie);
        }
        finally {
            if (existing == null) {
                this.data.tasksInProgress().remove(key);
            }
        }
    }

    private X509CRL loadCrl(String key, Callable<X509CRL> loader, long currentTime) throws Exception {
        X509CRL crl = loader.call();
        if (crl == null) {
            log.warnf("Loading crl with key '%s' returned null.", (Object)key);
            return null;
        }
        long lifespan = this.getLifespan(crl, currentTime);
        if (lifespan > 0L) {
            this.data.cache().put((Object)key, (Object)new X509CRLEntry(crl, currentTime), lifespan, TimeUnit.MILLISECONDS);
            log.debugf("The crl with key '%s' was retrieved successfully and cached for %d millis.", (Object)key, (Object)lifespan);
        } else {
            this.data.cache().put((Object)key, (Object)new X509CRLEntry(crl, currentTime));
            log.debugf("The crl with key '%s' was retrieved successfully and cached forever.", (Object)key);
        }
        return crl;
    }

    private long getLifespan(X509CRL crl, long currentTime) {
        long cacheTime = this.data.cacheTime();
        if (crl.getNextUpdate() == null) {
            return cacheTime;
        }
        long nextUpdateTime = crl.getNextUpdate().getTime() - currentTime;
        if (nextUpdateTime <= 0L) {
            return this.data.minTimeBetweenRequests();
        }
        if (cacheTime > 0L) {
            return Math.min(cacheTime, nextUpdateTime);
        }
        return nextUpdateTime;
    }

    protected static interface SharedData {
        public Cache<String, X509CRLEntry> cache();

        public Map<String, FutureTask<X509CRL>> tasksInProgress();

        public long cacheTime();

        public long minTimeBetweenRequests();
    }
}

