/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.httpclient;

import java.io.IOException;
import java.io.InputStream;

public class SafeInputStream
extends InputStream {
    private long bytesConsumed;
    private final InputStream delegate;
    private final long maxBytesToConsume;

    public SafeInputStream(InputStream delegate, long maxBytesToConsume) {
        this.delegate = delegate;
        this.maxBytesToConsume = maxBytesToConsume;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int sizeRead = this.delegate.read(b, off, len);
        if (sizeRead > 0) {
            this.bytesConsumed += (long)sizeRead;
        }
        this.checkConsumedBytes();
        return sizeRead;
    }

    private void checkConsumedBytes() throws IOException {
        if (this.bytesConsumed > this.maxBytesToConsume) {
            throw new IOException(String.format("Response is at least %s bytes in size, with max bytes to be consumed being %d", this.bytesConsumed, this.maxBytesToConsume));
        }
    }

    @Override
    public int read() throws IOException {
        int result = this.delegate.read();
        if (result > 0) {
            ++this.bytesConsumed;
        }
        this.checkConsumedBytes();
        return result;
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }
}

