/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.set;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.multimap.impl.ExternalizerIds;
import org.infinispan.multimap.impl.SetBucket;
import org.infinispan.multimap.impl.function.set.SetBucketBaseFunction;

public final class SMIsMember<K, V>
implements SetBucketBaseFunction<K, V, List<Long>> {
    public static final AdvancedExternalizer<SMIsMember> EXTERNALIZER = new Externalizer();
    private final V[] values;

    public SMIsMember(V ... values) {
        this.values = values;
    }

    public List<Long> apply(EntryView.ReadWriteEntryView<K, SetBucket<V>> entryView) {
        ArrayList<Long> result = new ArrayList<Long>();
        Optional existing = entryView.peek();
        SetBucket<V> s = existing.isPresent() ? (SetBucket)existing.get() : new SetBucket<V>();
        for (V v : this.values) {
            result.add(s.contains(v) ? 1L : 0L);
        }
        return result;
    }

    private static class Externalizer
    implements AdvancedExternalizer<SMIsMember> {
        private Externalizer() {
        }

        public Set<Class<? extends SMIsMember>> getTypeClasses() {
            return Collections.singleton(SMIsMember.class);
        }

        public Integer getId() {
            return ExternalizerIds.SET_MISMEMBER_FUNCTION;
        }

        public void writeObject(ObjectOutput output, SMIsMember object) throws IOException {
            output.writeInt(object.values.length);
            for (Object el : object.values) {
                output.writeObject(el);
            }
        }

        public SMIsMember readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            int size = input.readInt();
            Object[] values = new Object[size];
            for (int i = 0; i < size; ++i) {
                values[i] = input.readObject();
            }
            return new SMIsMember(values);
        }
    }
}

