/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.ReadWriteMapImpl;
import org.infinispan.multimap.impl.ListBucket;
import org.infinispan.multimap.impl.function.list.IndexFunction;
import org.infinispan.multimap.impl.function.list.IndexOfFunction;
import org.infinispan.multimap.impl.function.list.InsertFunction;
import org.infinispan.multimap.impl.function.list.OfferFunction;
import org.infinispan.multimap.impl.function.list.PollFunction;
import org.infinispan.multimap.impl.function.list.RemoveCountFunction;
import org.infinispan.multimap.impl.function.list.ReplaceListFunction;
import org.infinispan.multimap.impl.function.list.RotateFunction;
import org.infinispan.multimap.impl.function.list.SetFunction;
import org.infinispan.multimap.impl.function.list.SubListFunction;
import org.infinispan.multimap.impl.function.list.TrimFunction;

public class EmbeddedMultimapListCache<K, V> {
    public static final String ERR_KEY_CAN_T_BE_NULL = "key can't be null";
    public static final String ERR_ELEMENT_CAN_T_BE_NULL = "element can't be null";
    public static final String ERR_VALUE_CAN_T_BE_NULL = "value can't be null";
    public static final String ERR_PIVOT_CAN_T_BE_NULL = "pivot can't be null";
    protected final FunctionalMap.ReadWriteMap<K, ListBucket<V>> readWriteMap;
    protected final AdvancedCache<K, ListBucket<V>> cache;
    protected final InternalEntryFactory entryFactory;

    public EmbeddedMultimapListCache(Cache<K, ListBucket<V>> cache) {
        this.cache = cache.getAdvancedCache();
        FunctionalMapImpl functionalMap = FunctionalMapImpl.create(this.cache);
        this.readWriteMap = ReadWriteMapImpl.create((FunctionalMapImpl)functionalMap);
        this.entryFactory = (InternalEntryFactory)ComponentRegistry.of(this.cache).getInternalEntryFactory().running();
    }

    public CompletionStage<Collection<V>> get(K key) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        return this.getEntry(key).thenApply(entry -> {
            if (entry != null) {
                return (Collection)entry.getValue();
            }
            return List.of();
        });
    }

    private CompletionStage<CacheEntry<K, Collection<V>>> getEntry(K key) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        return this.cache.getAdvancedCache().getCacheEntryAsync(key).thenApply(entry -> {
            if (entry == null) {
                return null;
            }
            return this.entryFactory.create(entry.getKey(), ((ListBucket)entry.getValue()).toDeque(), entry.getMetadata());
        });
    }

    public CompletionStage<Void> offerFirst(K key, V value) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        Objects.requireNonNull(value, ERR_VALUE_CAN_T_BE_NULL);
        return this.readWriteMap.eval(key, new OfferFunction(value, true));
    }

    public CompletionStage<Void> offerLast(K key, V value) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        Objects.requireNonNull(value, ERR_VALUE_CAN_T_BE_NULL);
        return this.readWriteMap.eval(key, new OfferFunction(value, false));
    }

    public CompletionStage<Void> offerFirst(K key, Collection<V> value) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        Objects.requireNonNull(value, ERR_VALUE_CAN_T_BE_NULL);
        return this.readWriteMap.eval(key, new OfferFunction(value, true));
    }

    public CompletionStage<Void> offerLast(K key, Collection<V> value) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        Objects.requireNonNull(value, ERR_VALUE_CAN_T_BE_NULL);
        return this.readWriteMap.eval(key, new OfferFunction(value, false));
    }

    public CompletionStage<Boolean> containsKey(K key) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        return this.cache.containsKeyAsync(key);
    }

    public CompletionStage<Long> size(K key) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        return this.cache.getAsync(key).thenApply(b -> b == null ? 0L : b.size());
    }

    public CompletionStage<V> index(K key, long index) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        return this.readWriteMap.eval(key, new IndexFunction(index));
    }

    public CompletionStage<Collection<V>> subList(K key, long from, long to) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        return this.readWriteMap.eval(key, new SubListFunction(from, to));
    }

    public CompletionStage<Collection<V>> pollFirst(K key, long count) {
        return this.poll(key, count, true);
    }

    public CompletionStage<Collection<V>> pollLast(K key, long count) {
        return this.poll(key, count, false);
    }

    public CompletableFuture<Collection<V>> poll(K key, long count, boolean first) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        EmbeddedMultimapListCache.requirePositive(count, "count can't be negative");
        return this.readWriteMap.eval(key, new PollFunction(first, count));
    }

    public CompletionStage<Boolean> set(K key, long index, V value) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        return this.readWriteMap.eval(key, new SetFunction(index, value));
    }

    public CompletionStage<Collection<Long>> indexOf(K key, V element, Long count, Long rank, Long maxlen) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        Objects.requireNonNull(element, ERR_ELEMENT_CAN_T_BE_NULL);
        long requestedCount = 1L;
        long requestedRank = 1L;
        long requestedMaxLen = 0L;
        if (count != null) {
            EmbeddedMultimapListCache.requirePositive(count, "count can't be negative");
            requestedCount = count;
        }
        if (rank != null) {
            EmbeddedMultimapListCache.requireNotZero(rank, "rank can't be zero");
            requestedRank = rank;
        }
        if (maxlen != null) {
            EmbeddedMultimapListCache.requirePositive(maxlen, "maxLen can't be negative");
            requestedMaxLen = maxlen;
        }
        return this.readWriteMap.eval(key, new IndexOfFunction(element, requestedCount, requestedRank, requestedMaxLen));
    }

    public CompletionStage<Long> insert(K key, boolean isBefore, V pivot, V element) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        Objects.requireNonNull(pivot, ERR_PIVOT_CAN_T_BE_NULL);
        Objects.requireNonNull(element, ERR_ELEMENT_CAN_T_BE_NULL);
        return this.readWriteMap.eval(key, new InsertFunction(isBefore, pivot, element));
    }

    public CompletionStage<Long> remove(K key, long count, V element) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        Objects.requireNonNull(element, ERR_ELEMENT_CAN_T_BE_NULL);
        return this.readWriteMap.eval(key, new RemoveCountFunction(count, element));
    }

    public CompletionStage<Boolean> trim(K key, long from, long to) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        return this.readWriteMap.eval(key, new TrimFunction(from, to));
    }

    public CompletionStage<Long> replace(K key, List<V> list) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        return this.readWriteMap.eval(key, new ReplaceListFunction(list));
    }

    public CompletionStage<V> rotate(K key, boolean rotateRight) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        return this.readWriteMap.eval(key, new RotateFunction(rotateRight));
    }

    private static void requirePositive(long number, String message) {
        if (number < 0L) {
            throw new IllegalArgumentException(message);
        }
    }

    private static void requireNotZero(long number, String message) {
        if (number == 0L) {
            throw new IllegalArgumentException(message);
        }
    }
}

