/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.util.HashMap;
import java.util.Map;
import twitter4j.AccountTotalsJSONImpl;
import twitter4j.DirectMessageJSONImpl;
import twitter4j.IDsJSONImpl;
import twitter4j.JSONException;
import twitter4j.JSONObject;
import twitter4j.JSONObjectType;
import twitter4j.LocationJSONImpl;
import twitter4j.OEmbedJSONImpl;
import twitter4j.PlaceJSONImpl;
import twitter4j.RateLimitStatusJSONImpl;
import twitter4j.RelationshipJSONImpl;
import twitter4j.SavedSearchJSONImpl;
import twitter4j.StatusDeletionNoticeImpl;
import twitter4j.StatusJSONImpl;
import twitter4j.TrendJSONImpl;
import twitter4j.TrendsJSONImpl;
import twitter4j.TwitterException;
import twitter4j.UserJSONImpl;
import twitter4j.UserListJSONImpl;
import twitter4j.v1.AccountTotals;
import twitter4j.v1.DirectMessage;
import twitter4j.v1.IDs;
import twitter4j.v1.Location;
import twitter4j.v1.OEmbed;
import twitter4j.v1.Place;
import twitter4j.v1.RateLimitStatus;
import twitter4j.v1.Relationship;
import twitter4j.v1.SavedSearch;
import twitter4j.v1.Status;
import twitter4j.v1.Trend;
import twitter4j.v1.Trends;
import twitter4j.v1.User;
import twitter4j.v1.UserList;

public final class TwitterObjectFactory {
    private static final ThreadLocal<Map> rawJsonMap = ThreadLocal.withInitial(HashMap::new);
    private static boolean registeredAtleastOnce = false;

    private TwitterObjectFactory() {
        throw new AssertionError((Object)"not intended to be instantiated.");
    }

    public static String getRawJSON(Object obj) {
        if (!registeredAtleastOnce) {
            throw new IllegalStateException("Apparently jsonStoreEnabled is not set to true.");
        }
        Object json = rawJsonMap.get().get(obj);
        if (json instanceof String) {
            return (String)json;
        }
        if (json != null) {
            return json.toString();
        }
        return null;
    }

    public static Status createStatus(String rawJSON) throws TwitterException {
        try {
            return new StatusJSONImpl(new JSONObject(rawJSON));
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    public static User createUser(String rawJSON) throws TwitterException {
        try {
            return new UserJSONImpl(new JSONObject(rawJSON));
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    public static AccountTotals createAccountTotals(String rawJSON) throws TwitterException {
        try {
            return new AccountTotalsJSONImpl(new JSONObject(rawJSON));
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    public static Relationship createRelationship(String rawJSON) throws TwitterException {
        try {
            return new RelationshipJSONImpl(new JSONObject(rawJSON));
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    public static Place createPlace(String rawJSON) throws TwitterException {
        try {
            return new PlaceJSONImpl(new JSONObject(rawJSON));
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    public static SavedSearch createSavedSearch(String rawJSON) throws TwitterException {
        try {
            return new SavedSearchJSONImpl(new JSONObject(rawJSON));
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    public static Trend createTrend(String rawJSON) throws TwitterException {
        try {
            return new TrendJSONImpl(new JSONObject(rawJSON));
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    public static Trends createTrends(String rawJSON) throws TwitterException {
        return new TrendsJSONImpl(rawJSON);
    }

    public static IDs createIDs(String rawJSON) throws TwitterException {
        return new IDsJSONImpl(rawJSON);
    }

    public static Map<String, RateLimitStatus> createRateLimitStatus(String rawJSON) throws TwitterException {
        try {
            return RateLimitStatusJSONImpl.createRateLimitStatuses(new JSONObject(rawJSON));
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    public static DirectMessage createDirectMessage(String rawJSON) throws TwitterException {
        try {
            return new DirectMessageJSONImpl(new JSONObject(rawJSON));
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    public static Location createLocation(String rawJSON) throws TwitterException {
        try {
            return new LocationJSONImpl(new JSONObject(rawJSON));
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    public static UserList createUserList(String rawJSON) throws TwitterException {
        try {
            return new UserListJSONImpl(new JSONObject(rawJSON));
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    public static OEmbed createOEmbed(String rawJSON) throws TwitterException {
        try {
            return new OEmbedJSONImpl(new JSONObject(rawJSON));
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    public static Object createObject(String rawJSON) throws TwitterException {
        try {
            JSONObject json = new JSONObject(rawJSON);
            JSONObjectType.Type jsonObjectType = JSONObjectType.determine(json);
            switch (jsonObjectType) {
                case SENDER: 
                case DIRECT_MESSAGE: {
                    return TwitterObjectFactory.registerJSONObject(new DirectMessageJSONImpl(json.getJSONObject("direct_message")), json);
                }
                case STATUS: {
                    return TwitterObjectFactory.registerJSONObject(new StatusJSONImpl(json), json);
                }
                case DELETE: {
                    return TwitterObjectFactory.registerJSONObject(new StatusDeletionNoticeImpl(json.getJSONObject("delete").getJSONObject("status")), json);
                }
                case LIMIT: {
                    return json;
                }
                case SCRUB_GEO: {
                    return json;
                }
            }
            return json;
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    static void clearThreadLocalMap() {
        rawJsonMap.get().clear();
    }

    static <T> T registerJSONObject(T key, Object json) {
        registeredAtleastOnce = true;
        rawJsonMap.get().put(key, json);
        return key;
    }
}

