/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import twitter4j.Authorization;
import twitter4j.Configuration;
import twitter4j.HttpClient;
import twitter4j.HttpParameter;
import twitter4j.HttpResponse;
import twitter4j.HttpResponseEvent;
import twitter4j.HttpResponseListener;
import twitter4j.JSONImplFactory;
import twitter4j.ObjectFactory;
import twitter4j.RateLimitStatusEvent;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterV1Impl;
import twitter4j.v1.ConnectionLifeCycleListener;
import twitter4j.v1.RateLimitStatus;
import twitter4j.v1.RawStreamListener;
import twitter4j.v1.StreamListener;
import twitter4j.v1.TwitterV1;

class TwitterImpl
implements Twitter,
HttpResponseListener,
Serializable {
    private static final long serialVersionUID = 9170943084096085770L;
    private final HttpClient http;
    private final String IMPLICIT_PARAMS_STR;
    private final HttpParameter[] IMPLICIT_PARAMS;
    private final ObjectFactory factory;
    private final String restBaseURL;
    private final boolean mbeanEnabled;
    private final String uploadBaseURL;
    private final String streamBaseURL;
    private final String streamThreadName;
    private transient List<ConnectionLifeCycleListener> connectionLifeCycleListeners;
    private transient List<StreamListener> streamListeners;
    private transient List<RawStreamListener> rawStreamListeners;
    private final boolean stallWarningsEnabled;
    private final boolean prettyDebug;
    private final boolean jsonStoreEnabled;
    private transient List<Consumer<RateLimitStatusEvent>> rateLimitStatusListeners;
    private transient List<Consumer<RateLimitStatusEvent>> rateLimitReachedListeners;
    private transient TwitterV1 twitterV1;
    @NotNull
    private final Authorization auth;

    TwitterImpl(Configuration conf) {
        boolean contributorsEnabled;
        conf.ensureAuthorizationEnabled();
        this.factory = conf.factory;
        this.restBaseURL = conf.restBaseURL;
        this.uploadBaseURL = conf.uploadBaseURL;
        this.http = conf.http;
        this.auth = conf.auth;
        this.mbeanEnabled = conf.mbeanEnabled;
        this.rateLimitStatusListeners = conf.rateLimitStatusListeners;
        this.rateLimitReachedListeners = conf.rateLimitReachedListeners;
        String implicitParamsStr = conf.includeEntitiesEnabled ? "include_entities=true" : "";
        boolean bl = contributorsEnabled = conf.contributingTo != -1L;
        if (contributorsEnabled) {
            if (!"".equals(implicitParamsStr)) {
                implicitParamsStr = implicitParamsStr + "&";
            }
            implicitParamsStr = implicitParamsStr + "contributingto=" + conf.contributingTo;
        }
        if (conf.tweetModeExtended) {
            if (!"".equals(implicitParamsStr)) {
                implicitParamsStr = implicitParamsStr + "&";
            }
            implicitParamsStr = implicitParamsStr + "tweet_mode=extended";
        }
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>(3);
        if (conf.includeEntitiesEnabled) {
            params.add(new HttpParameter("include_entities", "true"));
        }
        if (contributorsEnabled) {
            params.add(new HttpParameter("contributingto", conf.contributingTo));
        }
        if (conf.trimUserEnabled) {
            params.add(new HttpParameter("trim_user", "1"));
        }
        if (conf.includeExtAltTextEnabled) {
            params.add(new HttpParameter("include_ext_alt_text", "true"));
        }
        if (conf.tweetModeExtended) {
            params.add(new HttpParameter("tweet_mode", "extended"));
        }
        this.streamBaseURL = conf.streamBaseURL;
        this.streamThreadName = conf.streamThreadName;
        this.jsonStoreEnabled = conf.jsonStoreEnabled;
        this.prettyDebug = conf.prettyDebug;
        if (conf instanceof Twitter.TwitterBuilder) {
            Twitter.TwitterBuilder builder = (Twitter.TwitterBuilder)conf;
            this.connectionLifeCycleListeners = builder.connectionLifeCycleListeners;
            this.streamListeners = builder.streamListeners;
            this.rawStreamListeners = builder.rawStreamListeners;
            this.stallWarningsEnabled = builder.stallWarningsEnabled;
        } else {
            this.connectionLifeCycleListeners = new ArrayList<ConnectionLifeCycleListener>();
            this.streamListeners = new ArrayList<StreamListener>();
            this.rawStreamListeners = new ArrayList<RawStreamListener>();
            this.stallWarningsEnabled = false;
        }
        this.IMPLICIT_PARAMS = params.toArray(new HttpParameter[0]);
        this.IMPLICIT_PARAMS_STR = implicitParamsStr;
        this.initTransients();
    }

    void initTransients() {
        this.twitterV1 = new TwitterV1Impl(this.http, this.factory, this.restBaseURL, this.streamBaseURL, this.uploadBaseURL, this.auth, this.mbeanEnabled, this.IMPLICIT_PARAMS, this.IMPLICIT_PARAMS_STR, this.rateLimitStatusListeners, this.rateLimitReachedListeners, this.streamThreadName, this.connectionLifeCycleListeners, this.streamListeners, this.rawStreamListeners, this.jsonStoreEnabled, this.prettyDebug, this.stallWarningsEnabled);
    }

    @Override
    public void httpResponseReceived(HttpResponseEvent event) {
        block8: {
            int statusCode;
            RateLimitStatus rateLimitStatus;
            if (this.rateLimitStatusListeners.size() == 0 && this.rateLimitReachedListeners.size() == 0) break block8;
            HttpResponse res = event.getResponse();
            TwitterException te = event.getTwitterException();
            if (te != null) {
                rateLimitStatus = te.getRateLimitStatus();
                statusCode = te.getStatusCode();
            } else {
                rateLimitStatus = JSONImplFactory.createRateLimitStatusFromResponseHeader(res);
                statusCode = res.getStatusCode();
            }
            if (rateLimitStatus != null) {
                RateLimitStatusEvent statusEvent = new RateLimitStatusEvent(this, rateLimitStatus, event.isAuthenticated());
                if (statusCode == 420 || statusCode == 503 || statusCode == 429) {
                    for (Consumer<RateLimitStatusEvent> listener : this.rateLimitStatusListeners) {
                        listener.accept(statusEvent);
                    }
                    for (Consumer<RateLimitStatusEvent> listener : this.rateLimitReachedListeners) {
                        listener.accept(statusEvent);
                    }
                } else {
                    for (Consumer<RateLimitStatusEvent> listener : this.rateLimitStatusListeners) {
                        listener.accept(statusEvent);
                    }
                }
            }
        }
    }

    @Override
    public TwitterV1 v1() {
        return this.twitterV1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TwitterImpl twitter = (TwitterImpl)o;
        return this.mbeanEnabled == twitter.mbeanEnabled && this.stallWarningsEnabled == twitter.stallWarningsEnabled && this.prettyDebug == twitter.prettyDebug && this.jsonStoreEnabled == twitter.jsonStoreEnabled && Objects.equals(this.http, twitter.http) && Objects.equals(this.IMPLICIT_PARAMS_STR, twitter.IMPLICIT_PARAMS_STR) && Arrays.equals(this.IMPLICIT_PARAMS, twitter.IMPLICIT_PARAMS) && Objects.equals(this.factory, twitter.factory) && Objects.equals(this.restBaseURL, twitter.restBaseURL) && Objects.equals(this.uploadBaseURL, twitter.uploadBaseURL) && Objects.equals(this.streamBaseURL, twitter.streamBaseURL) && Objects.equals(this.streamThreadName, twitter.streamThreadName) && Objects.equals(this.connectionLifeCycleListeners, twitter.connectionLifeCycleListeners) && Objects.equals(this.streamListeners, twitter.streamListeners) && Objects.equals(this.rawStreamListeners, twitter.rawStreamListeners) && Objects.equals(this.rateLimitStatusListeners, twitter.rateLimitStatusListeners) && Objects.equals(this.rateLimitReachedListeners, twitter.rateLimitReachedListeners) && Objects.equals(this.twitterV1, twitter.twitterV1) && this.auth.equals(twitter.auth);
    }

    public int hashCode() {
        return Objects.hash(this.auth);
    }

    public String toString() {
        return "TwitterImpl{http=" + this.http + ", IMPLICIT_PARAMS_STR='" + this.IMPLICIT_PARAMS_STR + '\'' + ", IMPLICIT_PARAMS=" + Arrays.toString(this.IMPLICIT_PARAMS) + ", factory=" + this.factory + ", restBaseURL='" + this.restBaseURL + '\'' + ", mbeanEnabled=" + this.mbeanEnabled + ", uploadBaseURL='" + this.uploadBaseURL + '\'' + ", streamBaseURL='" + this.streamBaseURL + '\'' + ", streamThreadName='" + this.streamThreadName + '\'' + ", connectionLifeCycleListeners=" + this.connectionLifeCycleListeners + ", streamListeners=" + this.streamListeners + ", rawStreamListeners=" + this.rawStreamListeners + ", stallWarningsEnabled=" + this.stallWarningsEnabled + ", prettyDebug=" + this.prettyDebug + ", jsonStoreEnabled=" + this.jsonStoreEnabled + ", rateLimitStatusListeners=" + this.rateLimitStatusListeners + ", rateLimitReachedListeners=" + this.rateLimitReachedListeners + ", twitterV1=" + this.twitterV1 + ", auth=" + this.auth + '}';
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.rateLimitReachedListeners = new ArrayList<Consumer<RateLimitStatusEvent>>();
        this.rateLimitStatusListeners = new ArrayList<Consumer<RateLimitStatusEvent>>();
        this.connectionLifeCycleListeners = new ArrayList<ConnectionLifeCycleListener>();
        this.streamListeners = new ArrayList<StreamListener>();
        this.rawStreamListeners = new ArrayList<RawStreamListener>();
        this.initTransients();
    }
}

