/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.sbom;

import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ResolvedDependency;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;

public class ApplicationComponent {
    public static final String SCOPE_RUNTIME = "runtime";
    public static final String SCOPE_DEVELOPMENT = "development";
    protected Path path;
    protected String distributionPath;
    protected ResolvedDependency dep;
    protected String pedigree;
    protected String scope;
    protected Collection<ArtifactCoords> dependencies = List.of();

    public static Builder builder() {
        return new Builder();
    }

    private ApplicationComponent() {
    }

    private ApplicationComponent(ApplicationComponent builder) {
        this.path = builder.path;
        this.distributionPath = builder.distributionPath;
        this.dep = builder.dep;
        this.pedigree = builder.pedigree;
        this.scope = builder.scope;
        this.dependencies = List.copyOf(builder.dependencies);
    }

    public Path getPath() {
        return this.path;
    }

    public String getDistributionPath() {
        return this.distributionPath;
    }

    public ResolvedDependency getResolvedDependency() {
        return this.dep;
    }

    public String getPedigree() {
        return this.pedigree;
    }

    public String getScope() {
        return this.scope == null ? (this.dep == null || this.dep.isRuntimeCp() ? SCOPE_RUNTIME : SCOPE_DEVELOPMENT) : this.scope;
    }

    public Collection<ArtifactCoords> getDependencies() {
        return this.dependencies;
    }

    protected ApplicationComponent ensureImmutable() {
        return this;
    }

    public static class Builder
    extends ApplicationComponent {
        private Builder() {
        }

        public Builder(ApplicationComponent component) {
            super(component);
        }

        public Builder setPath(Path componentPath) {
            this.path = componentPath;
            return this;
        }

        public Builder setDistributionPath(String distributionPath) {
            this.distributionPath = distributionPath;
            return this;
        }

        public Builder setResolvedDependency(ResolvedDependency dep) {
            this.dep = dep;
            if (this.dependencies.isEmpty()) {
                this.dependencies = dep.getDependencies();
            }
            return this;
        }

        public Builder setPedigree(String pedigree) {
            this.pedigree = pedigree;
            return this;
        }

        public Builder setDevelopmentScope() {
            return this.setScope(ApplicationComponent.SCOPE_DEVELOPMENT);
        }

        public Builder setScope(String scope) {
            this.scope = scope;
            return this;
        }

        public Builder setDependencies(Collection<ArtifactCoords> dependencies) {
            this.dependencies = dependencies;
            return this;
        }

        public ApplicationComponent build() {
            return this.ensureImmutable();
        }

        @Override
        protected ApplicationComponent ensureImmutable() {
            return new ApplicationComponent(this);
        }
    }
}

