/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.devmode;

import io.quarkus.dev.spi.HotReplacementContext;
import io.quarkus.dev.spi.HotReplacementSetup;
import io.quarkus.vertx.http.runtime.StaticResourcesRecorder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class StaticResourcesHotReplacementSetup
implements HotReplacementSetup {
    public void setupHotDeployment(HotReplacementContext context) {
        ArrayList<Path> resources = new ArrayList<Path>();
        for (Path classesDir : context.getClassesDir()) {
            this.addPathIfContainsStaticResources(resources, classesDir);
        }
        for (Path resourceDir : context.getResourcesDir()) {
            this.addPathIfContainsStaticResources(resources, resourceDir);
        }
        StaticResourcesRecorder.setHotDeploymentResources(resources);
    }

    public void handleFailedInitialStart() {
    }

    public void close() {
        StaticResourcesRecorder.setHotDeploymentResources(null);
    }

    private void addPathIfContainsStaticResources(List<Path> resources, Path resourceDir) {
        Path resource = resourceDir.resolve("META-INF/resources");
        resources.add(resource);
    }
}

