/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.keycloak.models.oid4vci.CredentialScopeModel;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CredentialDefinition {
    @JsonProperty(value="@context")
    private List<String> context;
    private List<String> type = new ArrayList<String>();

    public static CredentialDefinition parse(CredentialScopeModel credentialModel) {
        List contexts = Optional.of(credentialModel.getVcContexts()).filter(list -> !list.isEmpty()).orElseGet(() -> new ArrayList<String>(List.of(credentialModel.getName())));
        List types = Optional.ofNullable(credentialModel.getSupportedCredentialTypes()).filter(list -> !list.isEmpty()).orElseGet(() -> new ArrayList<String>(List.of(credentialModel.getName())));
        return new CredentialDefinition().setContext(contexts).setType(types);
    }

    public List<String> getContext() {
        return this.context;
    }

    public CredentialDefinition setContext(List<String> context) {
        this.context = context;
        return this;
    }

    public List<String> getType() {
        return this.type;
    }

    public CredentialDefinition setType(List<String> type) {
        this.type = type;
        return this;
    }
}

