/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto;

import org.keycloak.common.VerificationException;
import org.keycloak.crypto.ClientEdDSASignatureVerifierContext;
import org.keycloak.crypto.ClientSignatureVerifierProvider;
import org.keycloak.crypto.SignatureVerifierContext;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;

public class EdDSAClientSignatureVerifierProvider
implements ClientSignatureVerifierProvider {
    private final KeycloakSession session;
    private final String algorithm;

    public EdDSAClientSignatureVerifierProvider(KeycloakSession session, String algorithm) {
        this.session = session;
        this.algorithm = algorithm;
    }

    public SignatureVerifierContext verifier(ClientModel client, JWSInput input) throws VerificationException {
        return new ClientEdDSASignatureVerifierContext(this.session, client, input);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public boolean isAsymmetricAlgorithm() {
        return true;
    }
}

