/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.versioning.irac;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import org.infinispan.container.versioning.InequalVersionComparisonResult;
import org.infinispan.container.versioning.irac.TopologyIracVersion;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.util.ByteString;
import org.infinispan.xsite.XSiteNamedCache;

@ProtoTypeId(value=1006)
public class IracEntryVersion {
    private final MapEntry[] vectorClock;

    private IracEntryVersion(MapEntry[] vectorClock) {
        this.vectorClock = vectorClock;
    }

    public static IracEntryVersion newVersion(ByteString site, TopologyIracVersion version) {
        return new IracEntryVersion(new MapEntry[]{new MapEntry(site, version)});
    }

    @ProtoFactory
    static IracEntryVersion protoFactory(List<MapEntry> entries) {
        Object[] vc = entries.toArray(new MapEntry[entries.size()]);
        Arrays.sort(vc);
        return new IracEntryVersion((MapEntry[])vc);
    }

    @ProtoField(number=1, collectionImplementation=ArrayList.class)
    List<MapEntry> entries() {
        return Arrays.asList(this.vectorClock);
    }

    public void forEach(BiConsumer<ByteString, TopologyIracVersion> consumer) {
        for (MapEntry entry : this.vectorClock) {
            consumer.accept(entry.site, entry.version);
        }
    }

    public InequalVersionComparisonResult compareTo(IracEntryVersion other) {
        VectorClockComparator comparator = new VectorClockComparator(Math.max(this.vectorClock.length, other.vectorClock.length));
        this.forEach(comparator::setOurs);
        other.forEach(comparator::setTheirs);
        Merger merger = Merger.NONE;
        for (VersionCompare v : comparator.values()) {
            merger = merger.accept(v);
        }
        return merger.result();
    }

    public IracEntryVersion merge(IracEntryVersion other) {
        if (other == null) {
            return this;
        }
        TreeMap<ByteString, TopologyIracVersion> copy = IracEntryVersion.toTreeMap(this.vectorClock);
        for (MapEntry entry : other.vectorClock) {
            copy.merge(entry.site, entry.version, TopologyIracVersion::max);
        }
        return new IracEntryVersion(IracEntryVersion.toMapEntryArray(copy));
    }

    public TopologyIracVersion getVersion(ByteString siteName) {
        int index = Arrays.binarySearch(this.vectorClock, IracEntryVersion.searchKey(siteName));
        return index >= 0 ? this.vectorClock[index].version : null;
    }

    public int getTopology(ByteString siteName) {
        TopologyIracVersion version = this.getVersion(siteName);
        return version == null ? 0 : version.getTopologyId();
    }

    public IracEntryVersion increment(ByteString siteName, int topologyId) {
        TreeMap<ByteString, TopologyIracVersion> map = IracEntryVersion.toTreeMap(this.vectorClock);
        TopologyIracVersion existing = map.get(siteName);
        if (existing == null) {
            map.put(siteName, TopologyIracVersion.newVersion(topologyId));
        } else {
            map.put(siteName, existing.increment(topologyId));
        }
        return new IracEntryVersion(IracEntryVersion.toMapEntryArray(map));
    }

    public String toString() {
        LinkedList entries = new LinkedList();
        this.forEach((site, version) -> entries.add(String.valueOf(site) + "=" + String.valueOf(version)));
        return "(" + String.join((CharSequence)", ", entries) + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IracEntryVersion other = (IracEntryVersion)o;
        return Arrays.equals(this.vectorClock, other.vectorClock);
    }

    public int hashCode() {
        return Arrays.hashCode(this.vectorClock);
    }

    private static MapEntry[] toMapEntryArray(TreeMap<ByteString, TopologyIracVersion> map) {
        int length = map.size();
        MapEntry[] entries = new MapEntry[length];
        int index = 0;
        for (Map.Entry<ByteString, TopologyIracVersion> e : map.entrySet()) {
            entries[index++] = new MapEntry(e.getKey(), e.getValue());
        }
        return entries;
    }

    private static TreeMap<ByteString, TopologyIracVersion> toTreeMap(MapEntry[] entries) {
        TreeMap<ByteString, TopologyIracVersion> copy = new TreeMap<ByteString, TopologyIracVersion>();
        for (MapEntry entry : entries) {
            copy.put(entry.site, entry.version);
        }
        return copy;
    }

    private static MapEntry searchKey(ByteString site) {
        return new MapEntry(site, null);
    }

    @ProtoTypeId(value=1008)
    public static class MapEntry
    implements Comparable<MapEntry> {
        final ByteString site;
        @ProtoField(value=2)
        final TopologyIracVersion version;

        @ProtoFactory
        MapEntry(String site, TopologyIracVersion version) {
            this(XSiteNamedCache.cachedByteString(site), version);
        }

        MapEntry(ByteString site, TopologyIracVersion version) {
            this.site = site;
            this.version = version;
        }

        @ProtoField(value=1)
        public String getSite() {
            return this.site.toString();
        }

        public String toString() {
            return "MapEntry{site='" + String.valueOf(this.site) + "', version=" + String.valueOf(this.version) + "}";
        }

        @Override
        public int compareTo(MapEntry o) {
            return this.site.compareTo(o.site);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MapEntry entry = (MapEntry)o;
            return this.site.equals(entry.site) && this.version.equals(entry.version);
        }

        public int hashCode() {
            int result = this.site.hashCode();
            result = 31 * result + this.version.hashCode();
            return result;
        }
    }

    private static class VectorClockComparator {
        private final Map<ByteString, VersionCompare> vectorClock;

        VectorClockComparator(int capacity) {
            this.vectorClock = new HashMap<ByteString, VersionCompare>(capacity);
        }

        public String toString() {
            return "VectorClock{vectorClock=" + String.valueOf(this.vectorClock) + "}";
        }

        void setOurs(ByteString site, TopologyIracVersion version) {
            VersionCompare v = this.vectorClock.get(site);
            if (v == null) {
                v = new VersionCompare();
                this.vectorClock.put(site, v);
            }
            v.ours = version;
            if (v.theirs == null) {
                v.theirs = TopologyIracVersion.NO_VERSION;
            }
        }

        void setTheirs(ByteString site, TopologyIracVersion version) {
            VersionCompare v = this.vectorClock.get(site);
            if (v == null) {
                v = new VersionCompare();
                this.vectorClock.put(site, v);
            }
            v.theirs = version;
            if (v.ours == null) {
                v.ours = TopologyIracVersion.NO_VERSION;
            }
        }

        Collection<VersionCompare> values() {
            return this.vectorClock.values();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum Merger {
        NONE{

            @Override
            Merger accept(VersionCompare versions) {
                int compare = versions.ours.compareTo(versions.theirs);
                if (compare < 0) {
                    return OLD;
                }
                if (compare > 0) {
                    return NEW;
                }
                return EQUALS;
            }

            @Override
            InequalVersionComparisonResult result() {
                throw new IllegalStateException();
            }
        }
        ,
        OLD{

            @Override
            Merger accept(VersionCompare versions) {
                int compare = versions.ours.compareTo(versions.theirs);
                if (compare < 0) {
                    return OLD;
                }
                if (compare > 0) {
                    return CONFLICT;
                }
                return OLD_OR_EQUALS;
            }

            @Override
            InequalVersionComparisonResult result() {
                return InequalVersionComparisonResult.BEFORE;
            }
        }
        ,
        OLD_OR_EQUALS{

            @Override
            Merger accept(VersionCompare versions) {
                int compare = versions.ours.compareTo(versions.theirs);
                return compare <= 0 ? OLD_OR_EQUALS : CONFLICT;
            }

            @Override
            InequalVersionComparisonResult result() {
                return InequalVersionComparisonResult.BEFORE;
            }
        }
        ,
        NEW{

            @Override
            Merger accept(VersionCompare versions) {
                int compare = versions.ours.compareTo(versions.theirs);
                if (compare > 0) {
                    return NEW;
                }
                if (compare < 0) {
                    return CONFLICT;
                }
                return NEW_OR_EQUALS;
            }

            @Override
            InequalVersionComparisonResult result() {
                return InequalVersionComparisonResult.AFTER;
            }
        }
        ,
        NEW_OR_EQUALS{

            @Override
            Merger accept(VersionCompare versions) {
                int compare = versions.ours.compareTo(versions.theirs);
                return compare < 0 ? CONFLICT : NEW_OR_EQUALS;
            }

            @Override
            InequalVersionComparisonResult result() {
                return InequalVersionComparisonResult.AFTER;
            }
        }
        ,
        EQUALS{

            @Override
            Merger accept(VersionCompare versions) {
                int compare = versions.ours.compareTo(versions.theirs);
                if (compare < 0) {
                    return OLD_OR_EQUALS;
                }
                if (compare > 0) {
                    return NEW_OR_EQUALS;
                }
                return EQUALS;
            }

            @Override
            InequalVersionComparisonResult result() {
                return InequalVersionComparisonResult.EQUAL;
            }
        }
        ,
        CONFLICT{

            @Override
            Merger accept(VersionCompare versions) {
                return CONFLICT;
            }

            @Override
            InequalVersionComparisonResult result() {
                return InequalVersionComparisonResult.CONFLICTING;
            }
        };


        abstract Merger accept(VersionCompare var1);

        abstract InequalVersionComparisonResult result();
    }

    private static class VersionCompare {
        TopologyIracVersion ours;
        TopologyIracVersion theirs;

        private VersionCompare() {
        }

        public String toString() {
            return "VersionCompare{ours=" + String.valueOf(this.ours) + ", theirs=" + String.valueOf(this.theirs) + "}";
        }
    }
}

