/*
 * Decompiled with CFR 0.152.
 */
package microsoft.sql;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class Vector
implements Serializable {
    private VectorDimensionType vectorType;
    private int dimensionCount;
    private Object[] data;

    public Vector(int dimensionCount, VectorDimensionType vectorType, Object[] data) {
        Vector.validateVectorParameters(dimensionCount, vectorType, data);
        this.dimensionCount = dimensionCount;
        this.vectorType = vectorType;
        this.data = data;
    }

    public Vector(int precision, int scale, Object[] data) {
        this(precision, Vector.getVectorDimensionTypeFromScaleValue(scale), data);
    }

    public Object[] getData() {
        return this.data;
    }

    public int getDimensionCount() {
        return this.dimensionCount;
    }

    public VectorDimensionType getVectorDimensionType() {
        return this.vectorType;
    }

    public String toString() {
        return "VECTOR(" + this.vectorType + ", " + this.dimensionCount + ") : " + (this.data != null ? Arrays.toString(this.data) : "null");
    }

    private static void validateVectorParameters(int dimensionCount, VectorDimensionType vectorType, Object[] data) {
        if (dimensionCount <= 0) {
            throw Vector.vectorException("R_InvalidVectorDimensionCount", new Object[0]);
        }
        if (vectorType == null) {
            throw Vector.vectorException("R_VectorDimensionTypeCannotBeNull", new Object[0]);
        }
        if (data != null) {
            if (data.length != dimensionCount) {
                throw Vector.vectorException("R_VectorDimensionCountMismatch", new Object[0]);
            }
            if (!(data instanceof Float[])) {
                throw Vector.vectorException("R_VectorDataTypeMismatch", new Object[0]);
            }
        }
    }

    private static IllegalArgumentException vectorException(String resourceKey, Object ... args) {
        try {
            MessageFormat form = new MessageFormat(ResourceBundle.getBundle("com.microsoft.sqlserver.jdbc.SQLServerResource").getString(resourceKey));
            return new IllegalArgumentException(form.format(args));
        }
        catch (MissingResourceException e) {
            return new IllegalArgumentException("Missing resource: " + resourceKey);
        }
    }

    private static VectorDimensionType getVectorDimensionTypeFromScaleValue(int scale) {
        switch (scale) {
            case 4: {
                return VectorDimensionType.FLOAT32;
            }
        }
        return VectorDimensionType.FLOAT32;
    }

    public static enum VectorDimensionType {
        FLOAT32;

    }
}

