/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.BinaryJdbcType;

public class UuidAsBinaryJdbcType
extends BinaryJdbcType {
    public static final UuidAsBinaryJdbcType INSTANCE = new UuidAsBinaryJdbcType();

    @Override
    public int getDdlTypeCode() {
        return -2;
    }

    @Override
    public int getDefaultSqlTypeCode() {
        return 3000;
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(final JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                byte[] bytes = rs.getBytes(paramIndex);
                return javaType.wrap(bytes == null || bytes.length == 16 ? bytes : Arrays.copyOf(bytes, 16), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                byte[] bytes = statement.getBytes(index);
                return javaType.wrap(bytes == null || bytes.length == 16 ? bytes : Arrays.copyOf(bytes, 16), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                byte[] bytes = statement.getBytes(name);
                return javaType.wrap(bytes == null || bytes.length == 16 ? bytes : Arrays.copyOf(bytes, 16), options);
            }
        };
    }
}

