/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.util.Collection;
import java.util.Objects;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.AdjustableBasicType;
import org.hibernate.type.BasicArrayType;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.BasicCollectionJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;

public class BasicCollectionType<C extends Collection<E>, E>
extends AbstractSingleColumnStandardBasicType<C>
implements AdjustableBasicType<C>,
BasicPluralType<C, E> {
    private final BasicType<E> baseDescriptor;
    private final String name;

    public BasicCollectionType(BasicType<E> baseDescriptor, JdbcType arrayJdbcType, BasicCollectionJavaType<C, E> collectionTypeDescriptor) {
        super(arrayJdbcType, collectionTypeDescriptor);
        this.baseDescriptor = baseDescriptor;
        this.name = BasicCollectionType.determineName(collectionTypeDescriptor, baseDescriptor);
    }

    private static String determineName(BasicCollectionJavaType<?, ?> collectionTypeDescriptor, BasicType<?> baseDescriptor) {
        String elementTypeName = BasicArrayType.determineElementTypeName(baseDescriptor);
        switch (collectionTypeDescriptor.getSemantics().getCollectionClassification()) {
            case BAG: 
            case ID_BAG: {
                return "Collection<" + elementTypeName + ">";
            }
            case LIST: {
                return "List<" + elementTypeName + ">";
            }
            case SET: {
                return "Set<" + elementTypeName + ">";
            }
            case SORTED_SET: {
                return "SortedSet<" + elementTypeName + ">";
            }
            case ORDERED_SET: {
                return "OrderedSet<" + elementTypeName + ">";
            }
        }
        return null;
    }

    @Override
    public BasicType<E> getElementType() {
        return this.baseDescriptor;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    protected boolean registerUnderJavaType() {
        return true;
    }

    @Override
    public <X> BasicType<X> resolveIndicatedType(JdbcTypeIndicators indicators, JavaType<X> domainJtd) {
        return this;
    }

    public boolean equals(Object o) {
        return o == this || o.getClass() == BasicCollectionType.class && Objects.equals(this.baseDescriptor, ((BasicCollectionType)o).baseDescriptor);
    }

    public int hashCode() {
        return this.baseDescriptor.hashCode();
    }
}

