/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal.script;

import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.tool.schema.internal.script.MultiLineSqlScriptExtractor;
import org.hibernate.tool.schema.internal.script.SingleLineSqlScriptExtractor;
import org.hibernate.tool.schema.spi.SqlScriptCommandExtractor;

public class SqlScriptExtractorInitiator
implements StandardServiceInitiator<SqlScriptCommandExtractor> {
    public static final SqlScriptExtractorInitiator INSTANCE = new SqlScriptExtractorInitiator();

    @Override
    public Class<SqlScriptCommandExtractor> getServiceInitiated() {
        return SqlScriptCommandExtractor.class;
    }

    @Override
    public SqlScriptCommandExtractor initiateService(Map<String, Object> configurationValues, ServiceRegistryImplementor registry) {
        Object explicitSettingValue = configurationValues.get("hibernate.hbm2ddl.import_files_sql_extractor");
        if (explicitSettingValue == null) {
            return SingleLineSqlScriptExtractor.INSTANCE;
        }
        if (explicitSettingValue instanceof SqlScriptCommandExtractor) {
            SqlScriptCommandExtractor commandExtractor = (SqlScriptCommandExtractor)explicitSettingValue;
            return commandExtractor;
        }
        String explicitSettingName = explicitSettingValue.toString().trim();
        if (explicitSettingName.isEmpty() || "single-line".equals(explicitSettingName)) {
            return SingleLineSqlScriptExtractor.INSTANCE;
        }
        if ("multi-line".equals(explicitSettingName)) {
            return MultiLineSqlScriptExtractor.INSTANCE;
        }
        ClassLoaderService classLoaderService = registry.requireService(ClassLoaderService.class);
        return this.instantiateExplicitCommandExtractor(explicitSettingName, classLoaderService);
    }

    private SqlScriptCommandExtractor instantiateExplicitCommandExtractor(String extractorClassName, ClassLoaderService classLoaderService) {
        try {
            return (SqlScriptCommandExtractor)classLoaderService.classForName(extractorClassName).newInstance();
        }
        catch (Exception e) {
            throw new HibernateException("Could not instantiate import sql command extractor [" + extractorClassName + "]", e);
        }
    }
}

