/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema;

public enum Action {
    NONE,
    CREATE_ONLY,
    DROP,
    CREATE,
    CREATE_DROP,
    VALIDATE,
    UPDATE,
    TRUNCATE,
    POPULATE;

    public static final String ACTION_NONE = "none";
    public static final String ACTION_DROP = "drop";
    public static final String ACTION_CREATE_ONLY = "create-only";
    public static final String ACTION_CREATE = "create";
    public static final String ACTION_CREATE_THEN_DROP = "create-drop";
    public static final String ACTION_VALIDATE = "validate";
    public static final String ACTION_UPDATE = "update";
    public static final String ACTION_POPULATE = "populate";
    public static final String SPEC_ACTION_NONE = "none";
    public static final String SPEC_ACTION_DROP = "drop";
    public static final String SPEC_ACTION_CREATE = "create";
    public static final String SPEC_ACTION_DROP_AND_CREATE = "drop-and-create";

    public String getExternalJpaName() {
        return switch (this.ordinal()) {
            case 0 -> "none";
            case 1 -> "create";
            case 2 -> "drop";
            case 3 -> SPEC_ACTION_DROP_AND_CREATE;
            default -> null;
        };
    }

    public String getExternalHbm2ddlName() {
        return switch (this.ordinal()) {
            case 0 -> "none";
            case 1 -> ACTION_CREATE_ONLY;
            case 2 -> "drop";
            case 3 -> "create";
            case 4 -> ACTION_CREATE_THEN_DROP;
            case 5 -> ACTION_VALIDATE;
            case 6 -> ACTION_UPDATE;
            case 8 -> ACTION_POPULATE;
            default -> null;
        };
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(externalJpaName=" + this.getExternalJpaName() + ", externalHbm2ddlName=" + this.getExternalHbm2ddlName() + ")";
    }

    public static Action interpretJpaSetting(Object value) {
        if (value == null) {
            return NONE;
        }
        if (value instanceof Action) {
            Action action = (Action)((Object)value);
            return action;
        }
        String name = value.toString().trim();
        if (name.isEmpty()) {
            return NONE;
        }
        for (Action action : Action.values()) {
            String jpaName = action.getExternalJpaName();
            if (jpaName == null || !jpaName.equals(name)) continue;
            return action;
        }
        for (Action action : Action.values()) {
            String hbm2ddlName = action.getExternalHbm2ddlName();
            if (hbm2ddlName == null || !hbm2ddlName.equals(name)) continue;
            return action;
        }
        for (Action action : Action.values()) {
            if (!action.name().equals(name)) continue;
            return action;
        }
        throw new IllegalArgumentException("Unrecognized JPA schema management action setting: '" + String.valueOf(value) + "'");
    }

    public static Action interpretHbm2ddlSetting(Object value) {
        if (value == null) {
            return NONE;
        }
        if (value instanceof Action) {
            Action action = (Action)((Object)value);
            return action;
        }
        String name = value.toString().trim();
        if (name.isEmpty()) {
            return NONE;
        }
        for (Action action : Action.values()) {
            String hbm2ddlName = action.getExternalHbm2ddlName();
            if (hbm2ddlName == null || !hbm2ddlName.equals(name)) continue;
            return action;
        }
        for (Action action : Action.values()) {
            String jpaName = action.getExternalJpaName();
            if (jpaName == null || !jpaName.equals(name)) continue;
            return action;
        }
        throw new IllegalArgumentException("Unrecognized 'hibernate.hbm2ddl.auto' setting: '" + name + "'");
    }
}

