/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.expression.AbstractSqmParameter;
import org.hibernate.query.sqm.tree.expression.SqmParameter;

public class SqmPositionalParameter<T>
extends AbstractSqmParameter<T> {
    private final int position;

    public SqmPositionalParameter(int position, boolean canBeMultiValued, NodeBuilder nodeBuilder) {
        this(position, canBeMultiValued, null, nodeBuilder);
    }

    public SqmPositionalParameter(int position, boolean canBeMultiValued, SqmBindableType<T> expressibleType, NodeBuilder nodeBuilder) {
        super(canBeMultiValued, expressibleType, nodeBuilder);
        this.position = position;
    }

    @Override
    public SqmPositionalParameter<T> copy(SqmCopyContext context) {
        SqmPositionalParameter existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmPositionalParameter expression = context.registerCopy(this, new SqmPositionalParameter(this.position, this.allowMultiValuedBinding(), this.getNodeType(), this.nodeBuilder()));
        this.copyTo(expression, context);
        return expression;
    }

    @Override
    public Integer getPosition() {
        return this.position;
    }

    @Override
    public SqmParameter<T> copy() {
        return new SqmPositionalParameter(this.getPosition(), this.allowMultiValuedBinding(), this.getNodeType(), this.nodeBuilder());
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitPositionalParameterExpression(this);
    }

    public String toString() {
        return "SqmPositionalParameter(" + this.getPosition() + ")";
    }

    @Override
    public String asLoggableText() {
        return "?" + this.getPosition();
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        hql.append('?');
        hql.append(this.getPosition());
    }

    @Override
    public int compareTo(SqmParameter<T> parameter) {
        int n;
        if (parameter instanceof SqmPositionalParameter) {
            SqmPositionalParameter positionalParameter = (SqmPositionalParameter)parameter;
            n = this.getPosition().compareTo(positionalParameter.getPosition());
        } else {
            n = 1;
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof SqmPositionalParameter)) return false;
        SqmPositionalParameter that = (SqmPositionalParameter)object;
        if (this.position != that.position) return false;
        return true;
    }

    public int hashCode() {
        return this.position;
    }
}

