/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.util.Objects;
import org.hibernate.query.sqm.BinaryArithmeticOperator;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.type.spi.TypeConfiguration;

public class SqmBinaryArithmetic<T>
extends AbstractSqmExpression<T>
implements SqmSelectableNode<T> {
    private final SqmExpression<?> lhsOperand;
    private final BinaryArithmeticOperator operator;
    private final SqmExpression<?> rhsOperand;

    public SqmBinaryArithmetic(BinaryArithmeticOperator operator, SqmExpression<?> lhsOperand, SqmExpression<?> rhsOperand, NodeBuilder nodeBuilder) {
        super((SqmBindableType)nodeBuilder.getTypeConfiguration().resolveArithmeticType(lhsOperand.getExpressible(), rhsOperand.getExpressible(), operator), nodeBuilder);
        this.lhsOperand = lhsOperand;
        this.operator = operator;
        this.rhsOperand = rhsOperand;
        if (lhsOperand.getExpressible() == null && TypeConfiguration.isDuration(rhsOperand.getExpressible()) && (operator == BinaryArithmeticOperator.ADD || operator == BinaryArithmeticOperator.SUBTRACT)) {
            return;
        }
        this.lhsOperand.applyInferableType(rhsOperand.getExpressible());
        this.rhsOperand.applyInferableType(lhsOperand.getExpressible());
    }

    public SqmBinaryArithmetic(BinaryArithmeticOperator operator, SqmExpression<?> lhsOperand, SqmExpression<?> rhsOperand, SqmBindableType<T> expressibleType, NodeBuilder nodeBuilder) {
        super(expressibleType, nodeBuilder);
        this.operator = operator;
        this.lhsOperand = lhsOperand;
        this.rhsOperand = rhsOperand;
        this.applyInferableType(expressibleType);
    }

    @Override
    public SqmBinaryArithmetic<T> copy(SqmCopyContext context) {
        SqmBinaryArithmetic existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmBinaryArithmetic expression = context.registerCopy(this, new SqmBinaryArithmetic(this.operator, (SqmExpression<?>)this.lhsOperand.copy(context), (SqmExpression<?>)this.rhsOperand.copy(context), this.getNodeType(), this.nodeBuilder()));
        this.copyTo(expression, context);
        return expression;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitBinaryArithmeticExpression(this);
    }

    public SqmExpression<?> getLeftHandOperand() {
        return this.lhsOperand;
    }

    public BinaryArithmeticOperator getOperator() {
        return this.operator;
    }

    public SqmExpression<?> getRightHandOperand() {
        return this.rhsOperand;
    }

    @Override
    protected void internalApplyInferableType(SqmBindableType<?> type) {
        this.rhsOperand.applyInferableType(type);
        this.lhsOperand.applyInferableType(type);
        super.internalApplyInferableType(type);
    }

    @Override
    public String asLoggableText() {
        return this.getOperator().toLoggableText(this.lhsOperand.asLoggableText(), this.rhsOperand.asLoggableText());
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        this.lhsOperand.appendHqlString(hql, context);
        hql.append(' ');
        hql.append(this.operator.getOperatorSqlText());
        hql.append(' ');
        this.rhsOperand.appendHqlString(hql, context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof SqmBinaryArithmetic)) return false;
        SqmBinaryArithmetic that = (SqmBinaryArithmetic)object;
        if (this.operator != that.operator) return false;
        if (!Objects.equals(this.lhsOperand, that.lhsOperand)) return false;
        if (!Objects.equals(this.rhsOperand, that.rhsOperand)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.lhsOperand, this.rhsOperand, this.operator});
    }
}

