/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.domain.AbstractSqmPath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmSingularPersistentAttribute;
import org.hibernate.spi.NavigablePath;

public abstract class AbstractSqmSimplePath<T>
extends AbstractSqmPath<T>
implements SqmSimplePath<T> {
    public AbstractSqmSimplePath(NavigablePath navigablePath, SqmPathSource<T> referencedPathSource, SqmPath<?> lhs, NodeBuilder nodeBuilder) {
        this(navigablePath, referencedPathSource, lhs, null, nodeBuilder);
    }

    public AbstractSqmSimplePath(NavigablePath navigablePath, SqmPathSource<T> referencedPathSource, SqmPath<?> lhs, String explicitAlias, NodeBuilder nodeBuilder) {
        super(navigablePath, referencedPathSource, lhs, nodeBuilder);
        this.setExplicitAlias(explicitAlias);
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        if (this.getLhs() != null) {
            this.getLhs().appendHqlString(hql, context);
            hql.append('.');
        }
        hql.append(this.getReferencedPathSource().getPathName());
    }

    @Override
    public SqmBindableType<T> getNodeType() {
        return this.getReferencedPathSource().getExpressible();
    }

    @Override
    public SqmPathSource<T> getReferencedPathSource() {
        SqmPathSource<Object> sqmPathSource;
        SqmPathSource pathSource = super.getReferencedPathSource();
        if (pathSource instanceof SqmSingularPersistentAttribute) {
            SqmSingularPersistentAttribute attribute = (SqmSingularPersistentAttribute)pathSource;
            sqmPathSource = attribute.getSqmPathSource();
        } else {
            sqmPathSource = pathSource;
        }
        return sqmPathSource;
    }

    @Override
    public SqmPathSource<T> getModel() {
        return super.getReferencedPathSource();
    }
}

