/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.internal.dynamic;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.query.results.FetchBuilder;
import org.hibernate.query.results.internal.dynamic.DynamicFetchBuilder;
import org.hibernate.query.results.internal.dynamic.DynamicFetchBuilderContainer;
import org.hibernate.query.results.internal.dynamic.DynamicFetchBuilderStandard;
import org.hibernate.sql.results.graph.Fetchable;

public abstract class AbstractFetchBuilderContainer<T extends AbstractFetchBuilderContainer<T>>
implements DynamicFetchBuilderContainer {
    private Map<Fetchable, FetchBuilder> fetchBuilderMap;

    protected AbstractFetchBuilderContainer() {
    }

    protected AbstractFetchBuilderContainer(AbstractFetchBuilderContainer<T> original) {
        if (original.fetchBuilderMap != null) {
            this.fetchBuilderMap = new HashMap<Fetchable, FetchBuilder>(original.fetchBuilderMap.size());
            for (Map.Entry<Fetchable, FetchBuilder> entry : original.fetchBuilderMap.entrySet()) {
                FetchBuilder fetchBuilder;
                FetchBuilder fetchBuilder2 = entry.getValue();
                if (fetchBuilder2 instanceof DynamicFetchBuilderStandard) {
                    DynamicFetchBuilderStandard dynamicFetchBuilderStandard = (DynamicFetchBuilderStandard)fetchBuilder2;
                    fetchBuilder = dynamicFetchBuilderStandard.cacheKeyInstance(this);
                } else {
                    fetchBuilder = entry.getValue().cacheKeyInstance();
                }
                FetchBuilder fetchBuilder3 = fetchBuilder;
                this.fetchBuilderMap.put(entry.getKey(), fetchBuilder3);
            }
        }
    }

    protected abstract String getPropertyBase();

    @Override
    public FetchBuilder findFetchBuilder(Fetchable fetchable) {
        return this.fetchBuilderMap == null ? null : this.fetchBuilderMap.get(fetchable);
    }

    public T addProperty(Fetchable fetchable, String columnAlias) {
        DynamicFetchBuilder fetchBuilder = this.addProperty(fetchable);
        fetchBuilder.addColumnAlias(columnAlias);
        return (T)this;
    }

    public T addProperty(Fetchable fetchable, String ... columnAliases) {
        DynamicFetchBuilder fetchBuilder = this.addProperty(fetchable);
        ArrayHelper.forEach(columnAliases, fetchBuilder::addColumnAlias);
        return (T)this;
    }

    @Override
    public DynamicFetchBuilder addProperty(Fetchable fetchable) {
        if (this.fetchBuilderMap == null) {
            this.fetchBuilderMap = new HashMap<Fetchable, FetchBuilder>();
        } else {
            FetchBuilder existing = this.fetchBuilderMap.get(fetchable);
            if (existing != null) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Fetch was already defined for %s.%s : %s", this.getPropertyBase(), fetchable, existing));
            }
        }
        DynamicFetchBuilderStandard fetchBuilder = new DynamicFetchBuilderStandard(fetchable);
        this.fetchBuilderMap.put(fetchable, fetchBuilder);
        return fetchBuilder;
    }

    @Override
    public void addFetchBuilder(Fetchable fetchable, FetchBuilder fetchBuilder) {
        if (this.fetchBuilderMap == null) {
            this.fetchBuilderMap = new HashMap<Fetchable, FetchBuilder>();
        }
        this.fetchBuilderMap.put(fetchable, fetchBuilder);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractFetchBuilderContainer that = (AbstractFetchBuilderContainer)o;
        return Objects.equals(this.fetchBuilderMap, that.fetchBuilderMap);
    }

    public int hashCode() {
        return this.fetchBuilderMap != null ? this.fetchBuilderMap.hashCode() : 0;
    }
}

