/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.ordering.ast;

import jakarta.persistence.criteria.Nulls;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.hibernate.grammars.ordering.OrderingParser;
import org.hibernate.grammars.ordering.OrderingParserBaseVisitor;
import org.hibernate.internal.util.QuotingHelper;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.ordering.TranslationContext;
import org.hibernate.metamodel.mapping.ordering.ast.DomainPath;
import org.hibernate.metamodel.mapping.ordering.ast.FunctionExpression;
import org.hibernate.metamodel.mapping.ordering.ast.OrderByComplianceViolation;
import org.hibernate.metamodel.mapping.ordering.ast.OrderingExpression;
import org.hibernate.metamodel.mapping.ordering.ast.OrderingSpecification;
import org.hibernate.metamodel.mapping.ordering.ast.PathConsumer;
import org.hibernate.metamodel.mapping.ordering.ast.SelfRenderingOrderingExpression;
import org.hibernate.query.SortDirection;
import org.hibernate.query.sqm.ParsingException;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;

public class ParseTreeVisitor
extends OrderingParserBaseVisitor<Object> {
    private final PathConsumer pathConsumer;
    private final TranslationContext translationContext;

    public ParseTreeVisitor(PluralAttributeMapping pluralAttributeMapping, TranslationContext translationContext) {
        this.pathConsumer = new PathConsumer(pluralAttributeMapping, translationContext);
        this.translationContext = translationContext;
    }

    @Override
    public List<OrderingSpecification> visitOrderByFragment(OrderingParser.OrderByFragmentContext ctx) {
        int size = ctx.getChildCount();
        int specificationCount = size + 1 >> 1;
        if (specificationCount == 1) {
            return Collections.singletonList(this.visitSortSpecification((OrderingParser.SortSpecificationContext)ctx.getChild(0)));
        }
        ArrayList<OrderingSpecification> specifications = new ArrayList<OrderingSpecification>(specificationCount);
        for (int i = 0; i < size; i += 2) {
            specifications.add(this.visitSortSpecification((OrderingParser.SortSpecificationContext)ctx.getChild(i)));
        }
        return specifications;
    }

    @Override
    public OrderingSpecification visitSortSpecification(OrderingParser.SortSpecificationContext parsedSpec) {
        ParseTree parseTree;
        assert (parsedSpec != null);
        assert (parsedSpec.expression() != null);
        OrderingExpression orderingExpression = (OrderingExpression)parsedSpec.getChild(0).accept((org.antlr.v4.runtime.tree.ParseTreeVisitor)this);
        if (this.translationContext.getJpaCompliance().isJpaOrderByMappingComplianceEnabled() && !(orderingExpression instanceof DomainPath)) {
            throw new OrderByComplianceViolation(String.format(Locale.ROOT, "@OrderBy expression (%s) is not a domain-model reference, which violates the Jakarta Persistence specification - %s", parsedSpec.expression().getText(), orderingExpression.toDescriptiveText()));
        }
        OrderingSpecification result = new OrderingSpecification(orderingExpression, parsedSpec.getChild(0).getText());
        int i = 1;
        if (parsedSpec.getChildCount() > i && (parseTree = parsedSpec.getChild(i)) instanceof OrderingParser.CollationSpecificationContext) {
            result.setCollation((String)parseTree.getChild(1).getChild(0).accept((org.antlr.v4.runtime.tree.ParseTreeVisitor)this));
            ++i;
        }
        if (parsedSpec.getChildCount() > i && (parseTree = parsedSpec.getChild(i)) instanceof OrderingParser.DirectionContext) {
            OrderingParser.DirectionContext directionCtx = (OrderingParser.DirectionContext)parseTree;
            if (((TerminalNode)directionCtx.getChild(0)).getSymbol().getType() == 16) {
                result.setSortOrder(SortDirection.ASCENDING);
            } else {
                result.setSortOrder(SortDirection.DESCENDING);
            }
            ++i;
        }
        if (parsedSpec.getChildCount() > i && (parseTree = parsedSpec.getChild(i)) instanceof OrderingParser.NullsPrecedenceContext) {
            OrderingParser.NullsPrecedenceContext nullsCtx = (OrderingParser.NullsPrecedenceContext)parseTree;
            if (((TerminalNode)nullsCtx.getChild(1)).getSymbol().getType() == 14) {
                result.setNullPrecedence(Nulls.FIRST);
            } else {
                result.setNullPrecedence(Nulls.LAST);
            }
        }
        return result;
    }

    @Override
    public OrderingExpression visitFunctionExpression(OrderingParser.FunctionExpressionContext ctx) {
        return this.visitFunction((OrderingParser.FunctionContext)ctx.getChild(0));
    }

    @Override
    public OrderingExpression visitIdentifierExpression(OrderingParser.IdentifierExpressionContext ctx) {
        return this.visitIdentifier((OrderingParser.IdentifierContext)ctx.getChild(0));
    }

    @Override
    public OrderingExpression visitDotIdentifierExpression(OrderingParser.DotIdentifierExpressionContext ctx) {
        return this.visitDotIdentifier((OrderingParser.DotIdentifierContext)ctx.getChild(0));
    }

    @Override
    public OrderingExpression visitDotIdentifier(OrderingParser.DotIdentifierContext ctx) {
        int size = ctx.getChildCount();
        int end = size - 1;
        String partName = (String)ctx.getChild(0).getChild(0).accept((org.antlr.v4.runtime.tree.ParseTreeVisitor)this);
        this.pathConsumer.consumeIdentifier(partName, partName, true, false);
        for (int i = 2; i < end; i += 2) {
            partName = (String)ctx.getChild(i).getChild(0).accept((org.antlr.v4.runtime.tree.ParseTreeVisitor)this);
            this.pathConsumer.consumeIdentifier(partName, partName, false, false);
        }
        partName = (String)ctx.getChild(end).getChild(0).accept((org.antlr.v4.runtime.tree.ParseTreeVisitor)this);
        this.pathConsumer.consumeIdentifier(partName, partName, false, true);
        return (OrderingExpression)((Object)this.pathConsumer.getConsumedPart());
    }

    @Override
    public OrderingExpression visitIdentifier(OrderingParser.IdentifierContext ctx) {
        String unquotedIdentifier = (String)ctx.getChild(0).accept((org.antlr.v4.runtime.tree.ParseTreeVisitor)this);
        SqmFunctionDescriptor descriptor = this.translationContext.getFactory().getQueryEngine().getSqmFunctionRegistry().findFunctionDescriptor(unquotedIdentifier);
        String identifier = ctx.getChild(0).getText();
        if (descriptor == null || descriptor.alwaysIncludesParentheses() || !unquotedIdentifier.equals(identifier)) {
            this.pathConsumer.consumeIdentifier(unquotedIdentifier, identifier, true, true);
            return (OrderingExpression)((Object)this.pathConsumer.getConsumedPart());
        }
        return new SelfRenderingOrderingExpression(unquotedIdentifier);
    }

    @Override
    public FunctionExpression visitFunction(OrderingParser.FunctionContext ctx) {
        ParseTree functionCtx = ctx.getChild(0);
        OrderingParser.FunctionArgumentsContext argumentsCtx = (OrderingParser.FunctionArgumentsContext)functionCtx.getChild(1);
        int size = argumentsCtx.getChildCount();
        int expressionsCount = size - 1 >> 1;
        FunctionExpression function = new FunctionExpression(functionCtx.getChild(0).getText(), expressionsCount);
        for (int i = 1; i < size; i += 2) {
            function.addArgument((OrderingExpression)argumentsCtx.getChild(i).accept((org.antlr.v4.runtime.tree.ParseTreeVisitor)this));
        }
        return function;
    }

    @Override
    public OrderingExpression visitFunctionArgument(OrderingParser.FunctionArgumentContext ctx) {
        return (OrderingExpression)ctx.getChild(0).accept((org.antlr.v4.runtime.tree.ParseTreeVisitor)this);
    }

    @Override
    public OrderingExpression visitLiteral(OrderingParser.LiteralContext ctx) {
        return new SelfRenderingOrderingExpression(ctx.getText());
    }

    @Override
    public String visitCollationSpecification(OrderingParser.CollationSpecificationContext ctx) {
        throw new IllegalStateException("Unexpected call to #visitCollationSpecification");
    }

    public Object visitTerminal(TerminalNode node) {
        return switch (node.getSymbol().getType()) {
            case -1 -> null;
            case 18 -> node.getText();
            case 19 -> QuotingHelper.unquoteIdentifier(node.getText());
            default -> throw new ParsingException("Unexpected terminal node [" + node.getText() + "]");
        };
    }
}

