/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.List;
import org.hibernate.MappingException;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PersistentClassVisitor;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.TableOwner;

public final class JoinedSubclass
extends Subclass
implements TableOwner {
    private Table table;
    private KeyValue key;

    public JoinedSubclass(PersistentClass superclass, MetadataBuildingContext metadataBuildingContext) {
        super(superclass, metadataBuildingContext);
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    @Override
    public void setTable(Table table) {
        this.table = table;
        this.getSuperclass().addSubclassTable(table);
    }

    @Override
    public KeyValue getKey() {
        return this.key;
    }

    public void setKey(KeyValue key) {
        this.key = key;
    }

    @Override
    public void validate(Metadata mapping) throws MappingException {
        super.validate(mapping);
        if (this.key != null && !this.key.isValid(mapping)) {
            throw new MappingException("subclass key mapping has wrong number of columns: " + this.getEntityName() + " type: " + this.key.getType().getName());
        }
    }

    @Override
    public List<Property> getReferenceableProperties() {
        return this.getProperties();
    }

    @Override
    public Object accept(PersistentClassVisitor mv) {
        return mv.accept(this);
    }
}

