/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.generator;

import org.hibernate.Incubating;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.boot.model.relational.internal.SqlStringGenerationContextImpl;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.Type;

@Incubating
public interface GeneratorCreationContext {
    public Database getDatabase();

    public ServiceRegistry getServiceRegistry();

    public String getDefaultCatalog();

    public String getDefaultSchema();

    public PersistentClass getPersistentClass();

    public RootClass getRootClass();

    public Property getProperty();

    default public Type getType() {
        return this.getProperty().getType();
    }

    default public SqlStringGenerationContext getSqlStringGenerationContext() {
        Database database = this.getDatabase();
        return SqlStringGenerationContextImpl.fromExplicit(database.getJdbcEnvironment(), database, this.getDefaultCatalog(), this.getDefaultSchema());
    }
}

