/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.env.internal;

import java.io.Reader;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.SQLException;
import org.hibernate.JDBCException;
import org.hibernate.engine.jdbc.LobCreationContext;
import org.hibernate.engine.jdbc.env.internal.BlobAndClobCreator;
import org.hibernate.engine.jdbc.env.internal.NonContextualLobCreator;

public class StandardLobCreator
extends BlobAndClobCreator {
    public static final LobCreationContext.Callback<NClob> CREATE_NCLOB_CALLBACK = Connection::createNClob;

    StandardLobCreator(LobCreationContext lobCreationContext, boolean useConnectionToCreateLob) {
        super(lobCreationContext, useConnectionToCreateLob);
    }

    @Override
    public NClob createNClob() {
        return this.lobCreationContext.fromContext(CREATE_NCLOB_CALLBACK);
    }

    @Override
    public NClob createNClob(String string) {
        try {
            NClob nclob = this.createNClob();
            nclob.setString(1L, string);
            return nclob;
        }
        catch (SQLException e) {
            throw new JDBCException("Unable to set NCLOB string after creation", e);
        }
    }

    @Override
    public NClob createNClob(Reader reader, long length) {
        return NonContextualLobCreator.INSTANCE.createNClob(reader, length);
    }
}

