/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.connections.internal;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.SimpleDatabaseVersion;
import org.hibernate.engine.jdbc.connections.internal.ConnectionProviderInitiator;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.DatabaseConnectionInfo;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;

public class DatabaseConnectionInfoImpl
implements DatabaseConnectionInfo {
    public static final String DEFAULT = "undefined/unknown";
    private final Class<?> connectionProviderClass;
    protected final String jdbcUrl;
    protected final String jdbcDriver;
    private final Class<? extends Dialect> dialectClass;
    protected final DatabaseVersion dialectVersion;
    private final boolean hasSchema;
    private final boolean hasCatalog;
    protected final String schema;
    protected final String catalog;
    protected final String autoCommitMode;
    protected final String isolationLevel;
    protected final Integer poolMinSize;
    protected final Integer poolMaxSize;
    private final Integer fetchSize;

    public DatabaseConnectionInfoImpl(Class<? extends ConnectionProvider> connectionProviderClass, String jdbcUrl, String jdbcDriver, Class<? extends Dialect> dialectClass, DatabaseVersion dialectVersion, boolean hasSchema, boolean hasCatalog, String schema, String catalog, String autoCommitMode, String isolationLevel, Integer poolMinSize, Integer poolMaxSize, Integer fetchSize) {
        this.connectionProviderClass = connectionProviderClass;
        this.jdbcUrl = StringHelper.nullIfEmpty(jdbcUrl);
        this.jdbcDriver = StringHelper.nullIfEmpty(jdbcDriver);
        this.dialectVersion = dialectVersion;
        this.hasSchema = hasSchema;
        this.hasCatalog = hasCatalog;
        this.schema = schema;
        this.catalog = catalog;
        this.autoCommitMode = StringHelper.nullIfEmpty(autoCommitMode);
        this.isolationLevel = StringHelper.nullIfEmpty(isolationLevel);
        this.poolMinSize = poolMinSize;
        this.poolMaxSize = poolMaxSize;
        this.fetchSize = fetchSize;
        this.dialectClass = dialectClass;
    }

    public DatabaseConnectionInfoImpl(Map<String, Object> settings, Dialect dialect) {
        this(null, DatabaseConnectionInfoImpl.determineUrl(settings), DatabaseConnectionInfoImpl.determineDriver(settings), dialect.getClass(), dialect.getVersion(), true, true, null, null, DatabaseConnectionInfoImpl.determineAutoCommitMode(settings), DatabaseConnectionInfoImpl.determineIsolationLevel(settings), null, DatabaseConnectionInfoImpl.determinePoolMaxSize(settings), null);
    }

    public DatabaseConnectionInfoImpl(Dialect dialect) {
        this(null, null, null, dialect.getClass(), dialect.getVersion(), true, true, null, null, null, null, null, null, null);
    }

    public static boolean hasSchema(Connection connection) {
        try {
            return connection.getMetaData().supportsSchemasInDataManipulation();
        }
        catch (SQLException ignored) {
            return true;
        }
    }

    public static boolean hasCatalog(Connection connection) {
        try {
            return connection.getMetaData().supportsCatalogsInDataManipulation();
        }
        catch (SQLException ignored) {
            return true;
        }
    }

    public static String getSchema(Connection connection) {
        try {
            return connection.getSchema();
        }
        catch (AbstractMethodError | SQLException ignored) {
            return null;
        }
    }

    public static String getCatalog(Connection connection) {
        try {
            return connection.getCatalog();
        }
        catch (SQLException ignored) {
            return null;
        }
    }

    public static Integer getFetchSize(Connection connection) {
        Integer n;
        block8: {
            Statement statement = connection.createStatement();
            try {
                n = statement.getFetchSize();
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ignored) {
                    return null;
                }
            }
            statement.close();
        }
        return n;
    }

    public static Integer getIsolation(Connection connection) {
        try {
            return connection.getTransactionIsolation();
        }
        catch (SQLException ignored) {
            return null;
        }
    }

    public static String getDriverName(Connection connection) {
        try {
            return connection.getMetaData().getDriverName();
        }
        catch (SQLException e) {
            return null;
        }
    }

    @Override
    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    @Override
    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    @Override
    public DatabaseVersion getDialectVersion() {
        return this.dialectVersion;
    }

    @Override
    public String getAutoCommitMode() {
        return this.autoCommitMode;
    }

    @Override
    public String getIsolationLevel() {
        return this.isolationLevel;
    }

    @Override
    public Integer getPoolMinSize() {
        return this.poolMinSize;
    }

    @Override
    public Integer getPoolMaxSize() {
        return this.poolMaxSize;
    }

    @Override
    public @Nullable Integer getJdbcFetchSize() {
        return this.fetchSize;
    }

    @Override
    public @Nullable String getSchema() {
        return this.schema;
    }

    @Override
    public @Nullable String getCatalog() {
        return this.catalog;
    }

    @Override
    public boolean hasSchema() {
        return this.hasSchema;
    }

    @Override
    public boolean hasCatalog() {
        return this.hasCatalog;
    }

    @Override
    public String toInfoString() {
        return "\tDatabase JDBC URL [%s]\n\tDatabase driver: %s\n\tDatabase dialect: %s\n\tDatabase version: %s\n\tDefault catalog/schema: %s/%s\n\tAutocommit mode: %s\n\tIsolation level: %s\n\tJDBC fetch size: %s\n\tPool: %s\n\tMinimum pool size: %s\n\tMaximum pool size: %s".formatted(DatabaseConnectionInfoImpl.handleEmpty(this.jdbcUrl), DatabaseConnectionInfoImpl.handleEmpty(this.jdbcDriver), DatabaseConnectionInfoImpl.handleEmpty(this.dialectClass), DatabaseConnectionInfoImpl.handleEmpty(this.dialectVersion), DatabaseConnectionInfoImpl.handleEmpty(this.catalog, this.hasCatalog), DatabaseConnectionInfoImpl.handleEmpty(this.schema, this.hasSchema), DatabaseConnectionInfoImpl.handleEmpty(this.autoCommitMode), DatabaseConnectionInfoImpl.handleEmpty(this.isolationLevel), DatabaseConnectionInfoImpl.handleFetchSize(this.fetchSize), DatabaseConnectionInfoImpl.handleEmpty(this.connectionProviderClass), DatabaseConnectionInfoImpl.handleEmpty(this.poolMinSize), DatabaseConnectionInfoImpl.handleEmpty(this.poolMaxSize));
    }

    private static String handleEmpty(String value) {
        return StringHelper.isNotEmpty(value) ? value : DEFAULT;
    }

    private static String handleEmpty(String value, boolean defined) {
        return StringHelper.isNotEmpty(value) ? value : (defined ? "unknown" : "undefined");
    }

    private static String handleEmpty(DatabaseVersion dialectVersion) {
        return dialectVersion != null ? dialectVersion.toString() : SimpleDatabaseVersion.ZERO_VERSION.toString();
    }

    private static String handleEmpty(Integer value) {
        return value != null ? value.toString() : DEFAULT;
    }

    private static String handleFetchSize(Integer value) {
        return value != null ? (value == 0 ? "none" : value.toString()) : DEFAULT;
    }

    private static String handleEmpty(Class<?> value) {
        return value != null ? value.getSimpleName() : DEFAULT;
    }

    private static String determineUrl(Map<String, Object> settings) {
        return (String)NullnessHelper.coalesceSuppliedValues(() -> ConfigurationHelper.getString("jakarta.persistence.jdbc.url", settings), () -> ConfigurationHelper.getString("hibernate.connection.url", settings), () -> ConfigurationHelper.getString("javax.persistence.jdbc.url", settings));
    }

    private static String determineDriver(Map<String, Object> settings) {
        return (String)NullnessHelper.coalesceSuppliedValues(() -> ConfigurationHelper.getString("jakarta.persistence.jdbc.driver", settings), () -> ConfigurationHelper.getString("hibernate.connection.driver_class", settings), () -> ConfigurationHelper.getString("javax.persistence.jdbc.driver", settings));
    }

    private static String determineAutoCommitMode(Map<String, Object> settings) {
        return ConfigurationHelper.getString("hibernate.connection.autocommit", settings);
    }

    private static String determineIsolationLevel(Map<String, Object> settings) {
        return ConnectionProviderInitiator.toIsolationNiceName(ConnectionProviderInitiator.interpretIsolation(settings.get("hibernate.connection.isolation")));
    }

    private static Integer determinePoolMaxSize(Map<String, Object> settings) {
        return ConfigurationHelper.getInteger("hibernate.connection.pool_size", settings);
    }
}

