/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.spi.interceptor;

import org.hibernate.engine.spi.SharedSessionContractImplementor;

public final class SessionAssociationMarkers {
    private static final SessionAssociationMarkers NON_ASSOCIATED = new SessionAssociationMarkers();
    final boolean allowLoadOutsideTransaction;
    final String sessionFactoryUuid;
    transient SharedSessionContractImplementor session;

    public SessionAssociationMarkers(SharedSessionContractImplementor session) {
        this.allowLoadOutsideTransaction = session.getFactory().getSessionFactoryOptions().isInitializeLazyStateOutsideTransactionsEnabled();
        this.sessionFactoryUuid = this.allowLoadOutsideTransaction ? session.getFactory().getUuid() : null;
        this.session = session;
    }

    private SessionAssociationMarkers() {
        this.allowLoadOutsideTransaction = false;
        this.sessionFactoryUuid = null;
        this.session = null;
    }

    private SessionAssociationMarkers(String sessionFactoryUuid) {
        this.allowLoadOutsideTransaction = true;
        this.sessionFactoryUuid = sessionFactoryUuid;
        this.session = null;
    }

    public SessionAssociationMarkers deAssociatedCopy() {
        if (this.allowLoadOutsideTransaction) {
            return new SessionAssociationMarkers(this.sessionFactoryUuid);
        }
        return NON_ASSOCIATED;
    }

    public void sessionClosed() {
        this.session = null;
    }
}

