/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.CollectionTable;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.UniqueConstraint;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.hibernate.boot.jaxb.mapping.spi.JaxbCollectionTableImpl;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.annotations.spi.CommonTableDetails;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.boot.models.xml.internal.XmlAnnotationHelper;
import org.hibernate.boot.models.xml.internal.db.ForeignKeyProcessing;
import org.hibernate.boot.models.xml.internal.db.JoinColumnProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.models.spi.ModelsContext;

public class CollectionTableJpaAnnotation
implements CollectionTable,
CommonTableDetails {
    private String name;
    private String catalog;
    private String schema;
    private JoinColumn[] joinColumns;
    private ForeignKey foreignKey;
    private UniqueConstraint[] uniqueConstraints;
    private Index[] indexes;
    private String options;

    public CollectionTableJpaAnnotation(ModelsContext modelContext) {
        this.name = "";
        this.catalog = "";
        this.schema = "";
        this.joinColumns = new JoinColumn[0];
        this.foreignKey = (ForeignKey)JpaAnnotations.FOREIGN_KEY.createUsage(modelContext);
        this.uniqueConstraints = new UniqueConstraint[0];
        this.indexes = new Index[0];
        this.options = "";
    }

    public CollectionTableJpaAnnotation(CollectionTable annotation, ModelsContext modelContext) {
        this.name = annotation.name();
        this.catalog = annotation.catalog();
        this.schema = annotation.schema();
        this.joinColumns = (JoinColumn[])OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.COLLECTION_TABLE, "joinColumns", modelContext);
        this.foreignKey = (ForeignKey)OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.COLLECTION_TABLE, "foreignKey", modelContext);
        this.uniqueConstraints = (UniqueConstraint[])OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.COLLECTION_TABLE, "uniqueConstraints", modelContext);
        this.indexes = (Index[])OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.COLLECTION_TABLE, "indexes", modelContext);
        this.options = (String)OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.COLLECTION_TABLE, "options", modelContext);
    }

    public CollectionTableJpaAnnotation(Map<String, Object> attributeValues, ModelsContext modelContext) {
        this.name = (String)attributeValues.get("name");
        this.catalog = (String)attributeValues.get("catalog");
        this.schema = (String)attributeValues.get("schema");
        this.joinColumns = (JoinColumn[])attributeValues.get("joinColumns");
        this.foreignKey = (ForeignKey)attributeValues.get("foreignKey");
        this.uniqueConstraints = (UniqueConstraint[])attributeValues.get("uniqueConstraints");
        this.indexes = (Index[])attributeValues.get("indexes");
        this.options = (String)attributeValues.get("options");
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return CollectionTable.class;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void name(String value) {
        this.name = value;
    }

    @Override
    public String catalog() {
        return this.catalog;
    }

    @Override
    public void catalog(String value) {
        this.catalog = value;
    }

    @Override
    public String schema() {
        return this.schema;
    }

    @Override
    public void schema(String value) {
        this.schema = value;
    }

    public JoinColumn[] joinColumns() {
        return this.joinColumns;
    }

    public void joinColumns(JoinColumn[] value) {
        this.joinColumns = value;
    }

    public ForeignKey foreignKey() {
        return this.foreignKey;
    }

    public void foreignKey(ForeignKey value) {
        this.foreignKey = value;
    }

    @Override
    public UniqueConstraint[] uniqueConstraints() {
        return this.uniqueConstraints;
    }

    @Override
    public void uniqueConstraints(UniqueConstraint[] value) {
        this.uniqueConstraints = value;
    }

    @Override
    public Index[] indexes() {
        return this.indexes;
    }

    @Override
    public void indexes(Index[] value) {
        this.indexes = value;
    }

    public String options() {
        return this.options;
    }

    public void options(String value) {
        this.options = value;
    }

    public void apply(JaxbCollectionTableImpl jaxbTable, XmlDocumentContext xmlDocumentContext) {
        XmlAnnotationHelper.applyOptionalString(jaxbTable.getName(), this::name);
        XmlAnnotationHelper.applyCatalog(jaxbTable, this, xmlDocumentContext);
        XmlAnnotationHelper.applySchema(jaxbTable, this, xmlDocumentContext);
        XmlAnnotationHelper.applyOptionalString(jaxbTable.getOptions(), this::options);
        this.joinColumns(JoinColumnProcessing.transformJoinColumnList(jaxbTable.getJoinColumns(), xmlDocumentContext));
        if (jaxbTable.getForeignKeys() != null) {
            this.foreignKey(ForeignKeyProcessing.createNestedForeignKeyAnnotation(jaxbTable.getForeignKeys(), xmlDocumentContext));
        }
        this.indexes(XmlAnnotationHelper.collectIndexes(jaxbTable.getIndexes(), xmlDocumentContext));
        this.uniqueConstraints(XmlAnnotationHelper.collectUniqueConstraints(jaxbTable.getUniqueConstraints(), xmlDocumentContext));
    }
}

