/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.streams.operators.spi;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ServiceLoader;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreamsFactory;

public class ReactiveStreamsFactoryResolver {
    private static volatile ReactiveStreamsFactory instance = null;

    protected ReactiveStreamsFactoryResolver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ReactiveStreamsFactory instance() {
        if (instance != null) return instance;
        Class<ReactiveStreamsFactoryResolver> clazz = ReactiveStreamsFactoryResolver.class;
        synchronized (ReactiveStreamsFactoryResolver.class) {
            ReactiveStreamsFactory newInstance;
            if (instance != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
            ClassLoader cl = AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
            if (cl == null) {
                cl = ReactiveStreamsFactory.class.getClassLoader();
            }
            if ((newInstance = ReactiveStreamsFactoryResolver.loadFromSpi(cl)) == null) {
                throw new IllegalStateException("No ReactiveStreamsFactory implementation found!");
            }
            instance = newInstance;
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static ReactiveStreamsFactory loadFromSpi(ClassLoader cl) {
        if (cl == null) {
            return null;
        }
        if (instance == null) {
            try {
                AccessController.doPrivileged(() -> {
                    ServiceLoader<ReactiveStreamsFactory> sl = ServiceLoader.load(ReactiveStreamsFactory.class, cl);
                    for (ReactiveStreamsFactory spi : sl) {
                        if (instance != null) {
                            throw new IllegalStateException("Multiple ReactiveStreamsFactory implementations found: " + spi.getClass().getName() + " and " + instance.getClass().getName());
                        }
                        instance = spi;
                    }
                    return null;
                });
            }
            catch (PrivilegedActionException e) {
                Throwable t = e.getCause();
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new RuntimeException(t);
            }
        }
        return instance;
    }

    public static void setInstance(ReactiveStreamsFactory factory) {
        instance = factory;
    }
}

