/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.Util;

public class TimedThreadDump {
    private static final Log log = LogFactory.getLog(TimedThreadDump.class);
    private final long interval = TimeUnit.SECONDS.toMillis(Long.getLong("infinispan.backpressure.dump.interval.sec", 60L));
    private long lastUse = 0L;
    private static final TimedThreadDump INSTANCE = new TimedThreadDump();

    private TimedThreadDump() {
    }

    public static TimedThreadDump instance() {
        return INSTANCE;
    }

    public static boolean generateThreadDump() {
        return TimedThreadDump.instance().generateThreadDump(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean generateThreadDump(long millisTime) {
        if (log.isTraceEnabled()) {
            boolean dump;
            TimedThreadDump timedThreadDump = this;
            synchronized (timedThreadDump) {
                boolean bl = dump = this.lastUse + this.interval < millisTime;
                if (dump) {
                    this.lastUse = millisTime;
                }
            }
            if (dump) {
                log.trace(Util.threadDump());
                return true;
            }
        }
        return false;
    }
}

