/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.api.configuration.supplier;

import io.agroal.api.configuration.AgroalConnectionPoolConfiguration;
import io.agroal.api.configuration.AgroalDataSourceConfiguration;
import io.agroal.api.configuration.supplier.AgroalConnectionPoolConfigurationSupplier;
import java.util.function.Function;
import java.util.function.Supplier;

public class AgroalDataSourceConfigurationSupplier
implements Supplier<AgroalDataSourceConfiguration> {
    AgroalConnectionPoolConfiguration connectionPoolConfiguration;
    AgroalDataSourceConfiguration.DataSourceImplementation dataSourceImplementation = AgroalDataSourceConfiguration.DataSourceImplementation.AGROAL;
    volatile boolean metrics;
    volatile AgroalDataSourceConfiguration.MetricsEnabledListener metricsEnabledListener;
    private volatile boolean lock = false;
    private AgroalConnectionPoolConfigurationSupplier connectionPoolConfigurationSupplier = new AgroalConnectionPoolConfigurationSupplier();

    private void checkLock() {
        if (this.lock) {
            throw new IllegalStateException("Attempt to modify an immutable configuration");
        }
    }

    public AgroalDataSourceConfigurationSupplier connectionPoolConfiguration(AgroalConnectionPoolConfiguration configuration) {
        this.checkLock();
        this.connectionPoolConfigurationSupplier = new AgroalConnectionPoolConfigurationSupplier(configuration);
        return this;
    }

    public AgroalDataSourceConfigurationSupplier connectionPoolConfiguration(Supplier<? extends AgroalConnectionPoolConfiguration> supplier) {
        return this.connectionPoolConfiguration(supplier.get());
    }

    public AgroalDataSourceConfigurationSupplier connectionPoolConfiguration(Function<? super AgroalConnectionPoolConfigurationSupplier, ? extends AgroalConnectionPoolConfigurationSupplier> function) {
        return this.connectionPoolConfiguration(function.apply(this.connectionPoolConfigurationSupplier));
    }

    public AgroalConnectionPoolConfigurationSupplier connectionPoolConfiguration() {
        return this.connectionPoolConfigurationSupplier;
    }

    public AgroalDataSourceConfigurationSupplier dataSourceImplementation(AgroalDataSourceConfiguration.DataSourceImplementation implementation) {
        this.checkLock();
        this.dataSourceImplementation = implementation;
        return this;
    }

    public AgroalDataSourceConfigurationSupplier metricsEnabled() {
        return this.metricsEnabled(true);
    }

    public AgroalDataSourceConfigurationSupplier metricsEnabled(boolean metricsEnabled) {
        this.checkLock();
        this.metrics = metricsEnabled;
        return this;
    }

    private void validate() {
        if (this.lock) {
            throw new IllegalStateException("Configuration already supplied");
        }
        if (this.connectionPoolConfigurationSupplier == null) {
            throw new IllegalArgumentException("Connection pool configuration not defined");
        }
        this.connectionPoolConfiguration = this.connectionPoolConfigurationSupplier.get();
    }

    @Override
    public AgroalDataSourceConfiguration get() {
        this.validate();
        this.lock = true;
        return new AgroalDataSourceConfiguration(){

            @Override
            public AgroalConnectionPoolConfiguration connectionPoolConfiguration() {
                return AgroalDataSourceConfigurationSupplier.this.connectionPoolConfiguration;
            }

            @Override
            public AgroalDataSourceConfiguration.DataSourceImplementation dataSourceImplementation() {
                return AgroalDataSourceConfigurationSupplier.this.dataSourceImplementation;
            }

            @Override
            public boolean metricsEnabled() {
                return AgroalDataSourceConfigurationSupplier.this.metrics;
            }

            @Override
            public void setMetricsEnabled(boolean metricsEnabled) {
                AgroalDataSourceConfigurationSupplier.this.metrics = metricsEnabled;
                if (AgroalDataSourceConfigurationSupplier.this.metricsEnabledListener != null) {
                    AgroalDataSourceConfigurationSupplier.this.metricsEnabledListener.onMetricsEnabled(metricsEnabled);
                }
            }

            @Override
            public void registerMetricsEnabledListener(AgroalDataSourceConfiguration.MetricsEnabledListener listener) {
                AgroalDataSourceConfigurationSupplier.this.metricsEnabledListener = listener;
            }
        };
    }
}

