/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow;

import jakarta.persistence.EntityManager;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.Subquery;
import java.util.ArrayList;
import java.util.List;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.jpa.entities.UserEntity;
import org.keycloak.models.workflow.EventBasedWorkflowProvider;
import org.keycloak.models.workflow.WorkflowConditionProvider;
import org.keycloak.models.workflow.WorkflowStateEntity;

public abstract class AbstractUserWorkflowProvider
extends EventBasedWorkflowProvider {
    private final EntityManager em;

    public AbstractUserWorkflowProvider(KeycloakSession session, ComponentModel model) {
        super(session, model);
        this.em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
    }

    @Override
    public List<String> getEligibleResourcesForInitialStep() {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(String.class);
        Root userRoot = query.from(UserEntity.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Subquery subquery = query.subquery(Integer.class);
        Root stateRoot = subquery.from(WorkflowStateEntity.class);
        subquery.select(cb.literal((Object)1));
        subquery.where((Expression)cb.and((Expression)cb.equal((Expression)stateRoot.get("resourceId"), (Expression)userRoot.get("id")), (Expression)cb.equal((Expression)stateRoot.get("workflowId"), (Object)this.getModel().getId())));
        Predicate notExistsPredicate = cb.not((Expression)cb.exists(subquery));
        predicates.add(notExistsPredicate);
        predicates.addAll(this.getConditionsPredicate(cb, (CriteriaQuery<String>)query, (Root<UserEntity>)userRoot));
        query.select((Selection)userRoot.get("id")).where(predicates);
        return this.em.createQuery(query).getResultList();
    }

    private List<Predicate> getConditionsPredicate(CriteriaBuilder cb, CriteriaQuery<String> query, Root<UserEntity> path) {
        MultivaluedHashMap config = this.getModel().getConfig();
        List conditions = (List)config.getOrDefault((Object)"conditions", List.of());
        if (conditions.isEmpty()) {
            return List.of();
        }
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        for (String providerId : conditions) {
            WorkflowConditionProvider condition = this.getManager().getConditionProvider(providerId, config);
            Predicate predicate = condition.toPredicate(cb, query, path);
            if (predicate == null) continue;
            predicates.add(predicate);
        }
        return predicates;
    }

    @Override
    public void close() {
    }

    protected EntityManager getEntityManager() {
        return this.em;
    }

    protected RealmModel getRealm() {
        return this.getSession().getContext().getRealm();
    }
}

