/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.transforms.field;

import java.util.Locale;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.Utils;

public enum FieldSyntaxVersion {
    V1,
    V2;

    public static final String FIELD_SYNTAX_VERSION_CONFIG = "field.syntax.version";
    public static final String FIELD_SYNTAX_VERSION_DOC = "Defines the version of the syntax to access fields. If set to `V1`, then the field paths are limited to access the elements at the root level of the struct or map. If set to `V2`, the syntax will support accessing nested elements. To access nested elements, dotted notation is used. If dots are already included in the field name, then backtick pairs can be used to wrap field names containing dots. E.g. to access the subfield `baz` from a field named \"foo.bar\" in a struct/map the following format can be used to access its elements: \"`foo.bar`.baz\".";
    public static final String FIELD_SYNTAX_VERSION_DEFAULT_VALUE;

    public static ConfigDef appendConfigTo(ConfigDef configDef) {
        return configDef.define(FIELD_SYNTAX_VERSION_CONFIG, ConfigDef.Type.STRING, (Object)FIELD_SYNTAX_VERSION_DEFAULT_VALUE, (ConfigDef.Validator)ConfigDef.CaseInsensitiveValidString.in((String[])Utils.enumOptions(FieldSyntaxVersion.class)), ConfigDef.Importance.HIGH, FIELD_SYNTAX_VERSION_DOC);
    }

    public static FieldSyntaxVersion fromConfig(AbstractConfig config) {
        String fieldSyntaxVersion = config.getString(FIELD_SYNTAX_VERSION_CONFIG);
        try {
            return FieldSyntaxVersion.valueOf(fieldSyntaxVersion.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new ConfigException(FIELD_SYNTAX_VERSION_CONFIG, (Object)fieldSyntaxVersion, "Unrecognized field syntax version");
        }
    }

    static {
        FIELD_SYNTAX_VERSION_DEFAULT_VALUE = V1.name();
    }
}

