/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.tls.TlsSRPIdentityManager;
import org.bouncycastle.tls.TlsSRPLoginParameters;
import org.bouncycastle.tls.crypto.SRP6Group;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsHMAC;
import org.bouncycastle.tls.crypto.TlsMAC;
import org.bouncycastle.tls.crypto.TlsSRP6VerifierGenerator;
import org.bouncycastle.tls.crypto.TlsSRPConfig;
import org.bouncycastle.util.Strings;

public class SimulatedTlsSRPIdentityManager
implements TlsSRPIdentityManager {
    private static final byte[] PREFIX_PASSWORD = Strings.toByteArray((String)"password");
    private static final byte[] PREFIX_SALT = Strings.toByteArray((String)"salt");
    protected SRP6Group group;
    protected TlsSRP6VerifierGenerator verifierGenerator;
    protected TlsMAC mac;

    public static SimulatedTlsSRPIdentityManager getRFC5054Default(TlsCrypto tlsCrypto, SRP6Group sRP6Group, byte[] byArray) throws IOException {
        TlsHMAC tlsHMAC = tlsCrypto.createHMAC(2);
        tlsHMAC.setKey(byArray, 0, byArray.length);
        TlsSRPConfig tlsSRPConfig = new TlsSRPConfig();
        tlsSRPConfig.setExplicitNG(new BigInteger[]{sRP6Group.getN(), sRP6Group.getG()});
        return new SimulatedTlsSRPIdentityManager(sRP6Group, tlsCrypto.createSRP6VerifierGenerator(tlsSRPConfig), tlsHMAC);
    }

    public SimulatedTlsSRPIdentityManager(SRP6Group sRP6Group, TlsSRP6VerifierGenerator tlsSRP6VerifierGenerator, TlsMAC tlsMAC) {
        this.group = sRP6Group;
        this.verifierGenerator = tlsSRP6VerifierGenerator;
        this.mac = tlsMAC;
    }

    @Override
    public TlsSRPLoginParameters getLoginParameters(byte[] byArray) {
        this.mac.update(PREFIX_SALT, 0, PREFIX_SALT.length);
        this.mac.update(byArray, 0, byArray.length);
        byte[] byArray2 = this.mac.calculateMAC();
        this.mac.update(PREFIX_PASSWORD, 0, PREFIX_PASSWORD.length);
        this.mac.update(byArray, 0, byArray.length);
        byte[] byArray3 = this.mac.calculateMAC();
        BigInteger bigInteger = this.verifierGenerator.generateVerifier(byArray2, byArray, byArray3);
        TlsSRPConfig tlsSRPConfig = new TlsSRPConfig();
        tlsSRPConfig.setExplicitNG(new BigInteger[]{this.group.getN(), this.group.getG()});
        return new TlsSRPLoginParameters(byArray, tlsSRPConfig, bigInteger, byArray2);
    }
}

