/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.collections;

import java.util.HashSet;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyString;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class StringArraySet
extends RubyArray {
    private final Set<String> set = new HashSet<String>(20);

    public StringArraySet(Ruby runtime2) {
        super(runtime2, 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void appendString(Ruby runtime2, String element) {
        RubyString item = runtime2.newString(element);
        StringArraySet stringArraySet = this;
        synchronized (stringArraySet) {
            super.append(runtime2.getCurrentContext(), item);
            this.set.add(element);
        }
    }

    @Override
    public synchronized RubyArray append(ThreadContext context, IRubyObject item) {
        RubyArray result2 = super.append(context, item);
        this.set.add(StringArraySet.convertToString(item));
        return result2;
    }

    @Override
    public synchronized IRubyObject rb_clear(ThreadContext context) {
        IRubyObject res = super.rb_clear(context);
        this.set.clear();
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deleteString(ThreadContext context, String element) {
        RubyString item = Create.newString(context, element);
        StringArraySet stringArraySet = this;
        synchronized (stringArraySet) {
            super.delete(context, item, Block.NULL_BLOCK);
            this.set.remove(element);
        }
    }

    @Override
    public synchronized IRubyObject delete(ThreadContext context, IRubyObject item, Block block) {
        IRubyObject result2 = super.delete(context, item, block);
        if (!this.includes(context, item)) {
            this.set.remove(StringArraySet.convertToString(item));
        }
        return result2;
    }

    @Override
    public synchronized IRubyObject delete_if(ThreadContext context, Block block) {
        IRubyObject result2 = super.delete_if(context, block);
        return result2;
    }

    @Override
    public final RubyBoolean include_p(ThreadContext context, IRubyObject item) {
        return Convert.asBoolean(context, this.containsString(StringArraySet.convertToString(item)));
    }

    @Override
    public synchronized IRubyObject replace(ThreadContext context, IRubyObject orig) {
        IRubyObject result2 = super.replace(context, orig);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject aset(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        IRubyObject result2 = super.aset(context, arg0, arg1);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject aset(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        IRubyObject result2 = super.aset(context, arg0, arg1, arg2);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized RubyArray collectBang(ThreadContext context, Block block) {
        RubyArray result2 = super.collectBang(context, block);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject compact_bang(ThreadContext context) {
        IRubyObject result2 = super.compact_bang(context);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject drop(ThreadContext context, IRubyObject n) {
        IRubyObject result2 = super.drop(context, n);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject drop_while(ThreadContext context, Block block) {
        IRubyObject result2 = super.drop_while(context, block);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject flatten_bang(ThreadContext context) {
        IRubyObject result2 = super.flatten_bang(context);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject flatten_bang(ThreadContext context, IRubyObject arg2) {
        IRubyObject result2 = super.flatten_bang(context, arg2);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject insert() {
        IRubyObject result2 = super.insert();
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject insert(ThreadContext context, IRubyObject arg2) {
        IRubyObject result2 = super.insert(context, arg2);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject insert(ThreadContext context, IRubyObject arg1, IRubyObject arg2) {
        IRubyObject result2 = super.insert(context, arg1, arg2);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject insert(ThreadContext context, IRubyObject[] args2) {
        IRubyObject result2 = super.insert(context, args2);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject pop(ThreadContext context) {
        IRubyObject result2 = super.pop(context);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject pop(ThreadContext context, IRubyObject num) {
        IRubyObject result2 = super.pop(context, num);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized RubyArray push(ThreadContext context, IRubyObject item) {
        RubyArray result2 = super.push(context, item);
        this.add(item);
        return result2;
    }

    @Override
    public synchronized RubyArray push(ThreadContext context, IRubyObject[] items) {
        RubyArray result2 = super.push(context, items);
        this.addAll(items);
        return result2;
    }

    @Override
    public synchronized IRubyObject rejectBang(ThreadContext context, Block block) {
        IRubyObject result2 = super.rejectBang(context, block);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject select_bang(ThreadContext context, Block block) {
        IRubyObject result2 = super.select_bang(context, block);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject shift(ThreadContext context) {
        IRubyObject result2 = super.shift(context);
        if (result2 != context.nil) {
            this.rehash();
        }
        return result2;
    }

    @Override
    public synchronized IRubyObject shift(ThreadContext context, IRubyObject num) {
        IRubyObject result2 = super.shift(context, num);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject slice_bang(ThreadContext context, IRubyObject arg0) {
        IRubyObject result2 = super.slice_bang(context, arg0);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject slice_bang(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        IRubyObject result2 = super.slice_bang(context, arg0, arg1);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject unshift(ThreadContext context) {
        IRubyObject result2 = super.unshift(context);
        return result2;
    }

    @Override
    public synchronized IRubyObject unshift(ThreadContext context, IRubyObject item) {
        IRubyObject result2 = super.unshift(context, item);
        this.add(item);
        return result2;
    }

    @Override
    public synchronized IRubyObject unshift(ThreadContext context, IRubyObject[] items) {
        IRubyObject result2 = super.unshift(context, items);
        this.addAll(items);
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean containsString(String element) {
        StringArraySet stringArraySet = this;
        synchronized (stringArraySet) {
            return this.set.contains(element);
        }
    }

    private static String convertToString(IRubyObject item) {
        return item.convertToString().asJavaString();
    }

    private void rehash() {
        this.set.clear();
        this.addAll(this.toJavaArrayMaybeUnsafe());
    }

    private void add(IRubyObject item) {
        this.set.add(StringArraySet.convertToString(item));
    }

    private void addAll(IRubyObject[] items) {
        for (IRubyObject item : items) {
            this.set.add(StringArraySet.convertToString(item));
        }
    }
}

