/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Map;
import org.jruby.RubyArray;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.MultipleAsgnBase;
import org.jruby.ir.operands.Array;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ReqdArgMultipleAsgnInstr
extends MultipleAsgnBase
implements FixedArityInstr {
    private final int preArgsCount;
    private final int postArgsCount;

    public ReqdArgMultipleAsgnInstr(Variable result2, Operand array2, int index2, int preArgsCount, int postArgsCount) {
        super(Operation.MASGN_REQD, result2, array2, index2);
        this.preArgsCount = preArgsCount;
        this.postArgsCount = postArgsCount;
    }

    public ReqdArgMultipleAsgnInstr(Variable result2, Operand array2, int index2) {
        this(result2, array2, index2, -1, -1);
    }

    public int getPreArgsCount() {
        return this.preArgsCount;
    }

    public int getPostArgsCount() {
        return this.postArgsCount;
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{"index: " + this.index, "pre: " + this.preArgsCount, "post: " + this.postArgsCount};
    }

    @Override
    public Operand simplifyOperands(IRScope scope, Map<Operand, Operand> valueMap) {
        this.simplifyOperands(valueMap, false);
        Operand val = this.getArray().getValue(valueMap);
        if (val instanceof Array) {
            Array a = (Array)val;
            int n = a.size();
            int i2 = IRRuntimeHelpers.irReqdArgMultipleAsgnIndex(n, this.preArgsCount, this.index, this.postArgsCount);
            return i2 == -1 ? scope.getManager().getNil() : a.get(i2);
        }
        return null;
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new ReqdArgMultipleAsgnInstr(ii.getRenamedVariable(this.result), this.getArray().cloneForInlining(ii), this.index, this.preArgsCount, this.postArgsCount);
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getPreArgsCount());
        e.encode(this.getPostArgsCount());
    }

    public static ReqdArgMultipleAsgnInstr decode(IRReaderDecoder d) {
        return new ReqdArgMultipleAsgnInstr(d.decodeVariable(), d.decodeOperand(), d.decodeInt(), d.decodeInt(), d.decodeInt());
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        RubyArray rubyArray = (RubyArray)this.getArray().retrieve(context, self2, currScope, currDynScope, temp);
        return IRRuntimeHelpers.irReqdArgMultipleAsgn(context, rubyArray, this.preArgsCount, this.index, this.postArgsCount);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.ReqdArgMultipleAsgnInstr(this);
    }
}

