/*
 * Decompiled with CFR 0.152.
 */
package jspecview.tree;

import javajs.util.Lst;
import jspecview.api.JSVPanel;
import jspecview.api.JSVTree;
import jspecview.api.JSVTreeNode;
import jspecview.api.JSVTreePath;
import jspecview.api.ScriptInterface;
import jspecview.common.JSVFileManager;
import jspecview.common.JSViewer;
import jspecview.common.PanelNode;
import jspecview.source.JDXSource;
import jspecview.tree.SimpleTreeModel;
import jspecview.tree.SimpleTreeNode;
import jspecview.tree.SimpleTreePath;

public class SimpleTree
implements JSVTree {
    protected ScriptInterface si;
    private JSVTreeNode rootNode;
    private SimpleTreeModel spectraTreeModel;
    protected JSViewer vwr;
    private SimpleTreePath selectedPath;

    @Override
    public JSVTreeNode getRootNode() {
        return this.rootNode;
    }

    public SimpleTree(JSViewer jSViewer) {
        this.vwr = jSViewer;
        this.rootNode = new SimpleTreeNode("Spectra", null);
        this.spectraTreeModel = new SimpleTreeModel(this.rootNode);
    }

    public void valueChanged() {
        this.vwr.selectedTreeNode(this.getLastSelectedPathComponent());
    }

    private JSVTreeNode getLastSelectedPathComponent() {
        return (JSVTreeNode)(this.selectedPath == null ? null : this.selectedPath.getLastPathComponent());
    }

    @Override
    public void setSelectedPanel(ScriptInterface scriptInterface, JSVPanel jSVPanel) {
        if (jSVPanel != null) {
            JSVTreeNode jSVTreeNode = PanelNode.findNode((JSVPanel)jSVPanel, this.vwr.panelNodes).treeNode;
            this.setSelectionPath(this.vwr.spectraTree.newTreePath(jSVTreeNode.getPath()));
        }
    }

    private void setSelectionPath(JSVTreePath jSVTreePath) {
        this.selectedPath = (SimpleTreePath)jSVTreePath;
        this.valueChanged();
    }

    @Override
    public JSVTreeNode createTree(int n, JDXSource jDXSource, JSVPanel[] jSVPanelArray) {
        SimpleTree simpleTree = (SimpleTree)this.vwr.spectraTree;
        JSVTreeNode jSVTreeNode = simpleTree.getRootNode();
        Lst<PanelNode> lst = this.vwr.panelNodes;
        String string = JSVFileManager.getTagName(jDXSource.getFilePath());
        PanelNode panelNode = new PanelNode(null, string, jDXSource, null);
        SimpleTreeNode simpleTreeNode = new SimpleTreeNode(string, panelNode);
        panelNode.setTreeNode(simpleTreeNode);
        simpleTree.spectraTreeModel.insertNodeInto(simpleTreeNode, jSVTreeNode, jSVTreeNode.getChildCount());
        int n2 = 0;
        while (n2 < jSVPanelArray.length) {
            JSVPanel jSVPanel = jSVPanelArray[n2];
            String string2 = String.valueOf(n) + "." + (n2 + 1);
            panelNode = new PanelNode(string2, string, jDXSource, jSVPanel);
            SimpleTreeNode simpleTreeNode2 = new SimpleTreeNode(panelNode.toString(), panelNode);
            panelNode.setTreeNode(simpleTreeNode2);
            lst.addLast(panelNode);
            simpleTree.spectraTreeModel.insertNodeInto(simpleTreeNode2, simpleTreeNode, simpleTreeNode.getChildCount());
            ++n2;
        }
        this.vwr.selectFrameNode(jSVPanelArray[0]);
        return simpleTreeNode;
    }

    @Override
    public void setPath(JSVTreePath jSVTreePath) {
        this.setSelectionPath(jSVTreePath);
    }

    @Override
    public JSVTreePath newTreePath(Object[] objectArray) {
        return new SimpleTreePath(objectArray);
    }

    @Override
    public void deleteNodes(Lst<JSVTreeNode> lst) {
        int n = 0;
        while (n < lst.size()) {
            this.spectraTreeModel.removeNodeFromParent((JSVTreeNode)lst.get(n));
            ++n;
        }
    }
}

