/*
 * Decompiled with CFR 0.152.
 */
package jspecview.source;

import jspecview.source.JDXDecompressor;

public class JDXDecompressorTest {
    private static String[] testLines = new String[]{"1JT%jX", "D7m9jNOj9RjLmoPKLMj4oJ8j7PJT%olJ3MnJj2J0j7MQpJ9j3j0TJ0J2j3PKmJ2KJ4Ok2J4Mk", "A4j5lqkJ4rNj0J6j3JTpPqPNj6K0%j1J1lnJ8k3Pj1%J3j8J6J2j0J%Jj1Pkj1RJ5nj2OnjJJ3", "Ak8K1MPj4Nj2RJQoKnJ0j8J5mQl4L0j5J7k2NJMTJ1noLNj0KkqLmJ7Lk3MJ7p%qoLJ3nRjoJQ", "b2TJ2j7Nj0J8jpLOlOj2Jj0RJ5pmqJ1lpJ1pPjKJjkPj2MjJ2j2Qj2k3L4qnJ4prmRKmoJ6J5r", "I82314Q00sQ01Q00S2J85%W3A000100"};
    private static double[][] testResults = new double[][]{{1.0, 2.0, 3.0, 3.0, 2.0, 1.0, 0.0, -1.0, -2.0, -3.0}, {47.0, -2.0, -3.0, 2.0, 8.0, -11.0, -2.0, -3.0, 0.0, -4.0, -10.0, -3.0, -1.0, 2.0, 6.0, -8.0, -14.0, 4.0, -13.0, -6.0, -5.0, -4.0, -4.0, -10.0, -13.0, 0.0, 4.0, -1.0, 0.0, -12.0, -2.0, -19.0, -15.0, -7.0, -14.0, 5.0, -8.0, -18.0, -28.0, -18.0, -6.0, -19.0, -12.0, -10.0, -14.0, -2.0, 0.0, 14.0, 20.0, -2.0, 12.0, 16.0, 14.0}, {14.0, -1.0, -4.0, -12.0, -14.0, 0.0, -9.0, -4.0, -14.0, 2.0, -11.0, -10.0, -9.0, -16.0, -9.0, -17.0, -10.0, -5.0, -21.0, -1.0, -1.0, -12.0, -1.0, -4.0, -9.0, 9.0, -14.0, -7.0, -18.0, -18.0, -5.0, -23.0, -7.0, 5.0, -5.0, -4.0, -4.0, -3.0, -14.0, -7.0, -9.0, -20.0, -11.0, 4.0, -1.0, -13.0, -7.0, -12.0, -13.0, -12.0, 1.0}, {1.0, -27.0, -6.0, -2.0, 5.0, -9.0, -4.0, -16.0, -7.0, -6.0, 2.0, -4.0, -2.0, -7.0, 3.0, -15.0, 0.0, -4.0, 4.0, -30.0, 0.0, -15.0, 2.0, -20.0, -15.0, -14.0, -10.0, -6.0, 5.0, 0.0, -6.0, -3.0, 2.0, -8.0, -6.0, -8.0, -16.0, -13.0, -17.0, 0.0, 3.0, -20.0, -16.0, 1.0, -6.0, -6.0, -14.0, -20.0, -17.0, -4.0, -9.0, 0.0, -1.0, -7.0, -6.0, 2.0}, {-22.0, -22.0, -10.0, -27.0, -22.0, -32.0, -14.0, -15.0, -22.0, -19.0, -13.0, -16.0, -10.0, -22.0, -21.0, -31.0, -22.0, -7.0, -14.0, -18.0, -26.0, -15.0, -18.0, -25.0, -14.0, -21.0, -14.0, -15.0, -13.0, -12.0, -13.0, -15.0, -8.0, -20.0, -16.0, -17.0, -5.0, -17.0, -9.0, -21.0, -44.0, -10.0, -18.0, -23.0, -9.0, -16.0, -25.0, -29.0, -20.0, -18.0, -22.0, -28.0, -12.0, 3.0, -6.0}, {982314.0, 983114.0, 983914.0, 984714.0, 985514.0, 986314.0, 987114.0, 987914.0, 988714.0, 989514.0, 990315.0, 991115.0, 991915.0, 992715.0, 993515.0, 994315.0, 995115.0, 995915.0, 996715.0, 997515.0, 998315.0, 999115.0, 999915.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0, 1000100.0}};
    private static double dx5 = -1.1069014507253627;
    private static double[][] testData = new double[][]{{0.0, 1.0, 10.0, -3.0}, {8191.0, -1.0, 8139.0, 14.0}, {8139.0, -1.0, 8089.0, 1.0}, {8089.0, -1.0, 8034.0, 2.0}, {6142.0, -1.0, 6088.0, -9.0}, {1374.2821, dx5, 1287.9438 - dx5, 1000100.0}};
    private static int testIndex = 5;

    public static void main(String[] stringArray) {
        int n = 0;
        while (n < 6) {
            JDXDecompressorTest.testRun(n);
            ++n;
        }
    }

    private static void testRun(int n) {
        JDXDecompressor jDXDecompressor = new JDXDecompressor(testLines[n], 0);
        int n2 = 0;
        while (jDXDecompressor.hasNext()) {
            double d;
            boolean bl;
            double d2 = jDXDecompressor.next();
            boolean bl2 = bl = d2 == (d = testResults[n][n2++]);
            if (bl) continue;
            System.err.println("test " + n + " failed " + n2 + ": " + d2 + " != " + d);
            return;
        }
        System.out.println("test " + n + " OK");
    }

    static void testCreate(int n) {
        JDXDecompressor jDXDecompressor = new JDXDecompressor(testLines[n], 0);
        int n2 = 1;
        System.out.println("new double[] {");
        while (jDXDecompressor.hasNext()) {
            System.out.print(jDXDecompressor.next() + ",");
            if (++n2 % 5 != 0) continue;
            System.out.println();
        }
        System.out.println("\n},");
    }

    static void testDemo(String[] stringArray) {
        double d;
        double d2;
        double d3;
        double d4;
        Object object;
        String string;
        if (stringArray.length == 0) {
            string = testLines[testIndex];
            object = testData[testIndex];
            d4 = object[0];
            d3 = object[1];
            d2 = object[2];
            d = object[3];
        } else {
            string = stringArray[0];
            d4 = 0.0;
            d3 = 1.0;
            d2 = -1.0;
            d = Double.NaN;
        }
        object = new JDXDecompressor(string, 0);
        int n = 0;
        while (((JDXDecompressor)object).hasNext()) {
            String string2 = string.substring(((JDXDecompressor)object).ich);
            if (n > 0) {
                d4 += d3;
            }
            System.out.println(String.valueOf(++n) + " " + d4 + " " + ((JDXDecompressor)object).next() + " " + string2);
        }
        if (d2 >= 0.0) {
            System.out.println("expected x " + d2 + " final x " + d4 + " expected y " + d + " final y " + ((JDXDecompressor)object).lastY);
        }
    }
}

