/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.webexport;

import javajs.util.PT;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.jmol.i18n.GT;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.webexport.JmolInstance;
import org.openscience.jmol.app.webexport.WebExport;
import org.openscience.jmol.app.webexport.WebPanel;

class ScriptButtons
extends WebPanel {
    ScriptButtons(Viewer vwr, JFileChooser fc, WebPanel[] webPanels, int panelIndex) {
        super(vwr, fc, webPanels, panelIndex);
        this.panelName = "script_btn";
        this.listLabel = GT.$("These names will be used for button labels");
    }

    @Override
    JPanel appletParamPanel() {
        SpinnerNumberModel appletSizeModel = new SpinnerNumberModel(WebExport.getScriptButtonPercent(), 20, 100, 5);
        this.appletSizeSpinnerP = new JSpinner(appletSizeModel);
        JPanel appletSizePPanel = new JPanel();
        appletSizePPanel.add(new JLabel(GT.$("% of window for JSmol width:")));
        appletSizePPanel.add(this.appletSizeSpinnerP);
        return appletSizePPanel;
    }

    @Override
    String fixHtml(String html) {
        int size = ((SpinnerNumberModel)this.appletSizeSpinnerP.getModel()).getNumber().intValue();
        int appletheightpercent = 100;
        int nbuttons = this.getInstanceList().getModel().getSize();
        if (!this.allSelectedWidgets().isEmpty()) {
            appletheightpercent = 85;
        }
        html = PT.rep(html, "@WIDTHPERCENT@", "" + size);
        html = PT.rep(html, "@LEFTPERCENT@", "" + (100 - size));
        html = PT.rep(html, "@NBUTTONS@", "" + nbuttons);
        html = PT.rep(html, "@HEIGHT@", "" + appletheightpercent);
        html = PT.rep(html, "@BOTTOMPERCENT@", "" + (100 - appletheightpercent));
        return html;
    }

    @Override
    String getAppletDefs(int i, String html, StringBuilder appletDefs, JmolInstance instance) {
        String name = instance.name;
        String buttonname = instance.javaname;
        String widgetDefs = "";
        int row = 0;
        if (!instance.whichWidgets.isEmpty()) {
            if (instance.whichWidgets.get(3)) {
                widgetDefs = widgetDefs + "<div class=\"widgetItemAnim\"> " + this.theWidgets.widgetList[3].getJavaScript(0, instance) + "</div>";
            }
            widgetDefs = widgetDefs + "<table><tbody><tr>";
            for (int j = 0; j < this.nWidgets; ++j) {
                if (j == 3 || !instance.whichWidgets.get(j)) continue;
                if (row == 3) {
                    widgetDefs = widgetDefs + "</tr><tr>";
                    row = 0;
                }
                widgetDefs = widgetDefs + "<td class=\"widgetItemScBtn\">" + this.theWidgets.widgetList[j].getJavaScript(0, instance) + "</td>";
                ++row;
            }
            widgetDefs = widgetDefs + "</tr></tbody></table>";
        }
        if (i == 0) {
            html = PT.rep(html, "@APPLETNAME0@", GT.escapeHTML(buttonname));
        }
        String s = this.htmlAppletTemplate;
        s = PT.rep(s, "@APPLETNAME0@", GT.escapeHTML(buttonname));
        s = PT.rep(s, "@NAME@", "&#x201C;" + GT.escapeHTML(name) + "&#x201D;");
        s = PT.rep(s, "@LABEL@", GT.escapeHTML(name));
        s = PT.rep(s, "@I@", "" + i);
        s = PT.rep(s, "@WIDGETSTR@", widgetDefs);
        appletDefs.append(s);
        return html;
    }
}

