/*
 * Decompiled with CFR 0.152.
 */
package jspecview.source;

import java.io.IOException;
import java.util.Iterator;
import javajs.util.SB;
import jspecview.common.Coordinate;
import jspecview.source.JDXSourceStreamTokenizer;
import org.jmol.util.Logger;

public class JDXDecompressor
implements Iterator<Double> {
    private double xFactor;
    private double yFactor;
    private int nPoints;
    private static final String delimiters = " ,\t\n";
    private static final int[] actions = new int[255];
    private static final int ACTION_INVALID = -1;
    private static final int ACTION_UNKNOWN = 0;
    private static final int ACTION_DIF = 1;
    private static final int ACTION_DUP = 2;
    private static final int ACTION_SQZ = 3;
    private static final int ACTION_NUMERIC = 4;
    private static final double INVALID_Y = Double.MAX_VALUE;
    int ich;
    private JDXSourceStreamTokenizer t;
    private double firstX;
    double lastX;
    private double maxY = Double.MIN_VALUE;
    private double minY = Double.MAX_VALUE;
    private boolean debugging;
    private Coordinate[] xyCoords;
    private String line;
    private int lineLen;
    private SB errorLog;
    private int lastDif = Integer.MIN_VALUE;
    private int dupCount;
    private int nptsFound;
    double lastY;
    private boolean isDIF = true;

    public double getMinY() {
        return this.minY;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public JDXDecompressor(JDXSourceStreamTokenizer t, double firstX, double lastX, double xFactor, double yFactor, int nPoints) {
        this.t = t;
        this.firstX = firstX;
        this.lastX = lastX;
        this.xFactor = xFactor;
        this.yFactor = yFactor;
        this.nPoints = nPoints;
        this.debugging = Logger.isActiveLevel(6);
    }

    public JDXDecompressor(String line, int lastY) {
        this.line = line.trim();
        this.lineLen = line.length();
        this.lastY = lastY;
    }

    public Coordinate[] decompressData(SB errorLog) {
        this.errorLog = errorLog;
        double deltaXcalc = Coordinate.deltaX(this.lastX, this.firstX, this.nPoints);
        if (this.debugging) {
            this.logError("firstX=" + this.firstX + " lastX=" + this.lastX + " xFactor=" + this.xFactor + " yFactor=" + this.yFactor + " deltaX=" + deltaXcalc + " nPoints=" + this.nPoints);
        }
        this.xyCoords = new Coordinate[this.nPoints];
        double difFracMax = 0.5;
        double prevXcheck = 0.0;
        int prevIpt = 0;
        double lastXExpected = this.lastX;
        double x = this.lastX = this.firstX;
        String lastLine = null;
        int ipt = 0;
        double yval = 0.0;
        boolean haveWarned = false;
        int lineNumber = this.t.labelLineNo;
        try {
            while ((this.line = this.t.readLineTrimmed()) != null && this.line.indexOf("##") < 0) {
                ++lineNumber;
                this.lineLen = this.line.length();
                if (this.lineLen == 0) continue;
                this.ich = 0;
                boolean isCheckPoint = this.isDIF;
                double xcheck = this.readSignedFloat() * this.xFactor;
                yval = this.nextValue(yval);
                if (!isCheckPoint && ipt > 0) {
                    x += deltaXcalc;
                }
                if (this.debugging) {
                    this.logError("Line: " + lineNumber + " isCP=" + isCheckPoint + "\t>>" + this.line + "<<\n x, xcheck " + x + " " + x / this.xFactor + " " + xcheck / this.xFactor + " " + deltaXcalc / this.xFactor);
                }
                double y = yval * this.yFactor;
                Coordinate point = new Coordinate().set(x, y);
                if (ipt == 0 || !isCheckPoint) {
                    this.addPoint(point, ipt++);
                } else if (ipt < this.nPoints) {
                    double lastY = this.xyCoords[ipt - 1].getYVal();
                    if (y != lastY) {
                        this.xyCoords[ipt - 1] = point;
                        this.logError(lastLine + "\n" + this.line + "\nY-value Checkpoint Error! Line " + lineNumber + " for y=" + y + " yLast=" + lastY);
                    }
                    if (xcheck == prevXcheck || xcheck < prevXcheck != deltaXcalc < 0.0) {
                        this.logError(lastLine + "\n" + this.line + "\nX-sequence Checkpoint Error! Line " + lineNumber + " order for xCheck=" + xcheck + " after prevXCheck=" + prevXcheck);
                    }
                    double xcheckDif = Math.abs(xcheck - prevXcheck);
                    double xiptDif = Math.abs((double)(ipt - prevIpt) * deltaXcalc);
                    double fracDif = Math.abs(xcheckDif - xiptDif) / xcheckDif;
                    if (this.debugging) {
                        System.err.println("JDXD fracDif = " + xcheck + "\t" + prevXcheck + "\txcheckDif=" + xcheckDif + "\txiptDif=" + xiptDif + "\tf=" + fracDif);
                    }
                    if (fracDif > difFracMax) {
                        this.logError(lastLine + "\n" + this.line + "\nX-value Checkpoint Error! Line " + lineNumber + " expected " + xiptDif + " but X-Sequence Check difference reads " + xcheckDif);
                    }
                }
                prevIpt = ipt == 1 ? 0 : ipt;
                prevXcheck = xcheck;
                int nX = 0;
                while (this.hasNext()) {
                    int ich0 = this.ich;
                    if (this.debugging) {
                        this.logError("line " + lineNumber + " char " + ich0 + ":" + this.line.substring(0, ich0) + ">>>>" + this.line.substring(this.ich));
                    }
                    if (Double.isNaN(yval = this.nextValue(yval))) {
                        this.logError("There was an error reading line " + lineNumber + " char " + ich0 + ":" + this.line.substring(0, ich0) + ">>>>" + this.line.substring(ich0));
                        continue;
                    }
                    x += deltaXcalc;
                    if (yval == Double.MAX_VALUE) {
                        yval = 0.0;
                        this.logError("Point marked invalid '?' for line " + lineNumber + " char " + ich0 + ":" + this.line.substring(0, ich0) + ">>>>" + this.line.substring(ich0));
                    }
                    this.addPoint(new Coordinate().set(x, yval * this.yFactor), ipt++);
                    if (!this.debugging) continue;
                    this.logError("nx=" + ++nX + " " + x + " " + x / this.xFactor + " yval=" + yval);
                }
                this.lastX = x;
                if (!haveWarned && ipt > this.nPoints) {
                    this.logError("! points overflow nPoints!");
                    haveWarned = true;
                }
                lastLine = this.line;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.checkZeroFill(ipt, lastXExpected);
        return this.xyCoords;
    }

    private void checkZeroFill(int ipt, double lastXExpected) {
        this.nptsFound = ipt;
        if (this.nPoints == this.nptsFound) {
            if (Math.abs(lastXExpected - this.lastX) > 1.0E-5) {
                this.logError("Something went wrong! The last X value was " + this.lastX + " but expected " + lastXExpected);
            }
        } else {
            this.logError("Decompressor did not find " + this.nPoints + " points -- instead " + this.nptsFound + " xyCoords.length set to " + this.nPoints);
            for (int i = this.nptsFound; i < this.nPoints; ++i) {
                this.addPoint(new Coordinate().set(0.0, Double.NaN), i);
            }
        }
    }

    private void addPoint(Coordinate pt, int ipt) {
        if (ipt >= this.nPoints) {
            return;
        }
        this.xyCoords[ipt] = pt;
        double y = pt.getYVal();
        if (y > this.maxY) {
            this.maxY = y;
        } else if (y < this.minY) {
            this.minY = y;
        }
        if (this.debugging) {
            this.logError("Coord: " + ipt + pt);
        }
    }

    private void logError(String s) {
        if (this.debugging) {
            Logger.debug(s);
        }
        System.err.println(s);
        this.errorLog.append(s).appendC('\n');
    }

    private double nextValue(double yval) {
        if (this.dupCount > 0) {
            return this.getDuplicate(yval);
        }
        char ch = this.skipUnknown();
        switch (actions[ch]) {
            case 1: {
                this.isDIF = true;
                this.lastDif = this.readNextInteger(ch == '%' ? 0 : (ch <= 'R' ? ch - 73 : 105 - ch));
                return yval + (double)this.lastDif;
            }
            case 2: {
                this.dupCount = this.readNextInteger(ch == 's' ? 9 : ch - 82) - 1;
                return this.getDuplicate(yval);
            }
            case 3: {
                yval = this.readNextSqueezedNumber(ch);
                break;
            }
            case 4: {
                --this.ich;
                yval = this.readSignedFloat();
                break;
            }
            case -1: {
                yval = Double.MAX_VALUE;
                break;
            }
            default: {
                yval = Double.NaN;
            }
        }
        this.isDIF = false;
        return yval;
    }

    private char skipUnknown() {
        char ch = '\u0000';
        while (this.ich < this.lineLen && actions[ch = this.line.charAt(this.ich++)] == 0) {
        }
        return ch;
    }

    private double readSignedFloat() throws NumberFormatException {
        int ich0 = this.ich;
        int ch = 0;
        while (this.ich < this.lineLen) {
            char c = this.line.charAt(this.ich);
            ch = c;
            if (delimiters.indexOf(c) < 0) break;
            ++this.ich;
        }
        double factor = 1.0;
        switch (ch) {
            case 45: {
                factor = -1.0;
            }
            case 43: {
                ich0 = ++this.ich;
            }
        }
        if (this.scanToNonnumeric() == 'E' && this.ich + 3 < this.lineLen) {
            switch (this.line.charAt(this.ich + 1)) {
                case '+': 
                case '-': {
                    this.ich += 4;
                    if (this.ich >= this.lineLen) break;
                    char c = this.line.charAt(this.ich);
                    ch = c;
                    if (c < '0' || ch > 57) break;
                    ++this.ich;
                }
            }
        }
        return factor * Double.parseDouble(this.line.substring(ich0, this.ich));
    }

    private double getDuplicate(double yval) {
        --this.dupCount;
        return this.isDIF ? yval + (double)this.lastDif : yval;
    }

    private int readNextInteger(int n) {
        char c = '\u0000';
        while (this.ich < this.lineLen && (c = this.line.charAt(this.ich)) >= '0' && c <= '9') {
            n = n * 10 + (n < 0 ? 48 - c : c - 48);
            ++this.ich;
        }
        return n;
    }

    private double readNextSqueezedNumber(char ch) {
        int ich0 = this.ich;
        this.scanToNonnumeric();
        return Double.parseDouble((ch > '`' ? 96 - ch : ch - 64) + this.line.substring(ich0, this.ich));
    }

    private char scanToNonnumeric() {
        char ch = '\u0000';
        while (this.ich < this.lineLen && ((ch = this.line.charAt(this.ich)) == '.' || ch >= '0' && ch <= '9')) {
            ++this.ich;
        }
        return this.ich < this.lineLen ? ch : (char)'\u0000';
    }

    public int getNPointsFound() {
        return this.nptsFound;
    }

    @Override
    public boolean hasNext() {
        return this.ich < this.lineLen || this.dupCount > 0;
    }

    @Override
    public Double next() {
        Double d;
        if (this.hasNext()) {
            this.lastY = this.nextValue(this.lastY);
            d = this.lastY;
        } else {
            d = null;
        }
        return d;
    }

    @Override
    public void remove() {
    }

    static {
        block7: for (int i = 37; i <= 115; ++i) {
            char c = (char)i;
            switch (c) {
                case '%': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': {
                    JDXDecompressor.actions[i] = 1;
                    continue block7;
                }
                case '+': 
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    JDXDecompressor.actions[i] = 4;
                    continue block7;
                }
                case '?': {
                    JDXDecompressor.actions[i] = -1;
                    continue block7;
                }
                case '@': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': {
                    JDXDecompressor.actions[i] = 3;
                    continue block7;
                }
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case 's': {
                    JDXDecompressor.actions[i] = 2;
                }
            }
        }
    }
}

