/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jzlib;

import com.jcraft.jzlib.Deflate;
import com.jcraft.jzlib.ZStream;

public class Deflater
extends ZStream {
    private static final int MAX_WBITS = 15;
    private static final int Z_STREAM_END = 1;
    private static final int Z_STREAM_ERROR = -2;
    private boolean finished = false;

    public Deflater init(int level, int bits, boolean nowrap) {
        if (bits == 0) {
            bits = 15;
        }
        this.finished = false;
        this.setAdler32();
        this.dstate = new Deflate(this);
        this.dstate.deflateInit2(level, nowrap ? -bits : bits);
        return this;
    }

    @Override
    public int deflate(int flush) {
        if (this.dstate == null) {
            return -2;
        }
        int ret = this.dstate.deflate(flush);
        if (ret == 1) {
            this.finished = true;
        }
        return ret;
    }

    @Override
    public int end() {
        this.finished = true;
        if (this.dstate == null) {
            return -2;
        }
        int ret = this.dstate.deflateEnd();
        this.dstate = null;
        this.free();
        return ret;
    }

    public int params(int level, int strategy) {
        if (this.dstate == null) {
            return -2;
        }
        return this.dstate.deflateParams(level, strategy);
    }

    public int setDictionary(byte[] dictionary, int dictLength) {
        if (this.dstate == null) {
            return -2;
        }
        return this.dstate.deflateSetDictionary(dictionary, dictLength);
    }

    @Override
    public boolean finished() {
        return this.finished;
    }

    public void finish() {
    }

    public long getBytesRead() {
        return this.dstate.getBytesRead();
    }

    public long getBytesWritten() {
        return this.dstate.getBytesWritten();
    }
}

