#!/bin/sh
#shellcheck shell=sh
#===============================================================================
# Copyright 2023 Intel Corporation.
#
# This software and the related documents are Intel copyrighted  materials,  and
# your use of  them is  governed by the  express license  under which  they were
# provided to you (License).  Unless the License provides otherwise, you may not
# use, modify, copy, publish, distribute,  disclose or transmit this software or
# the related documents without Intel's prior written permission.
#
# This software and the related documents  are provided as  is,  with no express
# or implied  warranties,  other  than those  that are  expressly stated  in the
# License.
#===============================================================================


# This etc/mkl/vars.sh script is intended to be sourced by oneapi-vars.sh script
# and is not intended to be sourced directly.


# ############################################################################
#
# Intel(R) oneAPI Math Kernel Library (oneMKL) vars.sh
# Arguments:
#
#   source <install-dir>/oneapi-vars.sh [--force] [--help] [mod [<MKL_interface>]]
#
#     mod (optional) - Set path to oneMKL F95 modules
#
#     <MKL_interface> (optional) - oneMKL programming interface for the
#                                  "mod" option to set path
#         lp64         : 4 bytes integer (default)
#         ilp64        : 8 bytes integer
#
# ############################################################################

if [ -z "${SETVARS_CALL:-}" ] ; then
  >&2 echo " "
  >&2 echo ":: ERROR: This script must be sourced by oneapi-vars.sh."
  >&2 echo "   Try 'source <install-dir>/oneapi-vars.sh --help' for help."
  >&2 echo " "
  return 255 2>/dev/null || exit 255
fi

if [ -z "${ONEAPI_ROOT:-}" ] ; then
  >&2 echo " "
  >&2 echo ":: ERROR: This script requires that the ONEAPI_ROOT env variable is set."
  >&2 echo "   Try 'source <install-dir>/oneapi-vars.sh --help' for help."
  >&2 echo " "
  return 254 2>/dev/null || exit 254
fi

# ############################################################################

# Constants
__mkl_tmp_MOD_NAME=mod

# Defaults
__mkl_tmp_MOD=
__mkl_tmp_LP64_ILP64=lp64
__mkl_tmp_MKLVARS_VERBOSE=

# Parse arguments
while [ -n "${1:-}" ]; do
    if   [ "$1" = "${__mkl_tmp_MOD_NAME}" ] ; then __mkl_tmp_MOD=${__mkl_tmp_MOD_NAME};
    elif [ "$1" = "lp64" ]                  ; then __mkl_tmp_LP64_ILP64=lp64;
    elif [ "$1" = "ilp64" ]                 ; then __mkl_tmp_LP64_ILP64=ilp64;
    elif [ "$1" = "verbose" ]               ; then __mkl_tmp_MKLVARS_VERBOSE=verbose;
    fi
    shift;
done

# Set environment variables
export MKLROOT="${ONEAPI_ROOT}"
if [ "${__mkl_tmp_MOD}" = "${__mkl_tmp_MOD_NAME}" ] ; then
    __mkl_tmp_CPATH="${MKLROOT}/include/mkl/intel64/${__mkl_tmp_LP64_ILP64}"
    export CPATH="${__mkl_tmp_CPATH}${CPATH+:${CPATH}}"
fi

if [ "${__mkl_tmp_MKLVARS_VERBOSE}" = "verbose" ] ; then
    echo MKLROOT=${MKLROOT}
    echo CPATH=${CPATH:-}
fi
