/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.actor.impl;

import groovyx.gpars.actor.Actor;
import groovyx.gpars.actor.impl.ActorReplyException;
import groovyx.gpars.actor.impl.MessageStream;
import java.util.ArrayList;

public abstract class ReplyingMessageStream
extends Actor {
    private static final long serialVersionUID = -4660316352077009411L;
    private MessageStream sender = null;

    protected final MessageStream getSender() {
        return this.sender;
    }

    protected final void setSender(MessageStream sender) {
        this.sender = sender;
    }

    protected final void reply(Object message) {
        if (this.sender == null) {
            throw new ActorReplyException("Cannot send replies. No sender has been registered.");
        }
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        try {
            this.sender.send(message);
        }
        catch (IllegalStateException e) {
            exceptions.add(e);
        }
        if (!exceptions.isEmpty()) {
            throw new ActorReplyException("Failed sending some replies. See the issues field for details", exceptions);
        }
    }

    protected final void replyIfExists(Object message) {
        if (this.sender == null) {
            return;
        }
        try {
            this.sender.send(message);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

