/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.thread.graph;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.testng.IDynamicGraph;
import org.testng.collections.Maps;
import org.testng.internal.AutoCloseableLock;
import org.testng.internal.RuntimeBehavior;
import org.testng.internal.thread.graph.PhoneyWorker;
import org.testng.internal.thread.graph.TestNGFutureTask;
import org.testng.log4testng.Logger;
import org.testng.thread.IThreadWorkerFactory;
import org.testng.thread.IWorker;

public class GraphOrchestrator<T> {
    private final ExecutorService service;
    private final IDynamicGraph<T> graph;
    private final Map<T, IWorker<T>> mapping = Maps.newConcurrentMap();
    private final Map<T, T> upstream = Maps.newConcurrentMap();
    private final Comparator<T> comparator;
    private final IThreadWorkerFactory<T> factory;
    private final AutoCloseableLock internalLock = new AutoCloseableLock();

    public GraphOrchestrator(ExecutorService service, IThreadWorkerFactory<T> factory, IDynamicGraph<T> graph, Comparator<T> comparator) {
        this.service = service;
        this.graph = graph;
        this.comparator = comparator;
        this.factory = factory;
    }

    public void run() {
        try (AutoCloseableLock ignore = this.internalLock.lock();){
            List<T> freeNodes = this.graph.getFreeNodes();
            if (this.comparator != null) {
                freeNodes.sort(this.comparator);
            }
            this.runNodes(freeNodes);
        }
    }

    private void runNodes(List<T> freeNodes) {
        List<IWorker<T>> workers = this.factory.createWorkers(freeNodes);
        this.mapNodeToWorker(workers, freeNodes);
        for (IWorker<T> worker : workers) {
            this.mapNodeToParent(freeNodes);
            this.setStatus(worker, IDynamicGraph.Status.RUNNING);
            try {
                TestNGFutureTask<T> task = new TestNGFutureTask<T>(worker, this::afterExecute);
                this.service.execute(task);
            }
            catch (Exception ex) {
                Logger.getLogger(GraphOrchestrator.class).error(ex.getMessage(), ex);
            }
        }
    }

    private void mapNodeToParent(List<T> freeNodes) {
        if (!RuntimeBehavior.enforceThreadAffinity()) {
            return;
        }
        for (T freeNode : freeNodes) {
            List<Object> nodes = this.graph.getDependenciesFor(freeNode);
            nodes.forEach(eachNode -> this.upstream.put(eachNode, freeNode));
        }
    }

    private void afterExecute(IWorker<T> r, Throwable t) {
        try (AutoCloseableLock ignore = this.internalLock.lock();){
            this.setStatus(r, this.computeStatus(r));
            if (this.graph.getNodeCount() == this.graph.getNodeCountWithStatus(IDynamicGraph.Status.FINISHED)) {
                this.service.shutdown();
            } else {
                List<T> freeNodes = this.graph.getFreeNodes();
                if (this.comparator != null) {
                    freeNodes.sort(this.comparator);
                }
                this.handleThreadAffinity(freeNodes);
                this.runNodes(freeNodes);
            }
        }
    }

    private void handleThreadAffinity(List<T> freeNodes) {
        if (!RuntimeBehavior.enforceThreadAffinity()) {
            return;
        }
        for (T node : freeNodes) {
            IWorker<T> w;
            T upstreamNode = this.upstream.get(node);
            if (upstreamNode == null || (w = this.mapping.get(upstreamNode)) == null) continue;
            long threadId = w.getCurrentThreadId();
            this.mapping.put(node, new PhoneyWorker(threadId));
        }
    }

    private IDynamicGraph.Status computeStatus(IWorker<T> worker) {
        IDynamicGraph.Status status = IDynamicGraph.Status.FINISHED;
        if (RuntimeBehavior.enforceThreadAffinity() && !worker.completed()) {
            status = IDynamicGraph.Status.READY;
        }
        return status;
    }

    private void setStatus(IWorker<T> worker, IDynamicGraph.Status status) {
        try (AutoCloseableLock ignore = this.internalLock.lock();){
            for (T m : worker.getTasks()) {
                this.graph.setStatus(m, status);
            }
        }
    }

    private void mapNodeToWorker(List<IWorker<T>> runnables, List<T> freeNodes) {
        if (!RuntimeBehavior.enforceThreadAffinity()) {
            return;
        }
        for (IWorker<T> runnable : runnables) {
            for (T freeNode : freeNodes) {
                IWorker<T> w = this.mapping.get(freeNode);
                if (w != null) {
                    long current = w.getThreadIdToRunOn();
                    runnable.setThreadIdToRunOn(current);
                }
                if (!runnable.toString().contains(freeNode.toString())) continue;
                this.mapping.put(freeNode, runnable);
            }
        }
    }
}

