/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.testng.ISuite;
import org.testng.log4testng.Logger;
import org.testng.xml.XmlSuite;

public final class ObjectBag {
    private static final Logger logger = Logger.getLogger(ObjectBag.class);
    private final Map<Class<?>, Object> bag = new ConcurrentHashMap();
    private static final Map<UUID, ObjectBag> instances = new ConcurrentHashMap<UUID, ObjectBag>();

    public static ObjectBag getInstance(ISuite suite) {
        return ObjectBag.getInstance(suite.getXmlSuite());
    }

    public static ObjectBag getInstance(XmlSuite xmlSuite) {
        return instances.computeIfAbsent(xmlSuite.SUITE_ID, k -> new ObjectBag());
    }

    public static void cleanup(ISuite suite) {
        UUID uid = suite.getXmlSuite().SUITE_ID;
        Optional.ofNullable(instances.get(uid)).ifPresent(ObjectBag::cleanup);
        instances.remove(uid);
    }

    public Object createIfRequired(Class<?> type, Supplier<Object> supplier) {
        return this.bag.computeIfAbsent(type, t -> supplier.get());
    }

    public void cleanup() {
        this.bag.values().stream().filter(it -> it instanceof ExecutorService).map(it -> (ExecutorService)it).forEach(ExecutorService::shutdown);
        this.bag.clear();
    }
}

