/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.jvm.toolchain.internal.InstallationLocation;
import org.gradle.jvm.toolchain.internal.InstallationSupplier;
import org.gradle.jvm.toolchain.internal.JdkCacheDirectory;
import org.gradle.jvm.toolchain.internal.ToolchainConfiguration;

public class AutoInstalledInstallationSupplier
implements InstallationSupplier {
    public static final String AUTO_DOWNLOAD = "org.gradle.java.installations.auto-download";
    private final ToolchainConfiguration configuration;
    private final JdkCacheDirectory cacheDirProvider;

    @Inject
    public AutoInstalledInstallationSupplier(ToolchainConfiguration configuration, JdkCacheDirectory cacheDirProvider) {
        this.configuration = configuration;
        this.cacheDirProvider = cacheDirProvider;
    }

    @Override
    public String getSourceName() {
        return "Auto-provisioned by Gradle";
    }

    @Override
    public Set<InstallationLocation> get() {
        if (this.configuration.isAutoDetectEnabled() || this.configuration.isDownloadEnabled()) {
            return this.cacheDirProvider.listJavaHomes().stream().map(this::asInstallation).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private InstallationLocation asInstallation(File javaHome) {
        return InstallationLocation.autoProvisioned(javaHome, this.getSourceName());
    }
}

