/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;

public abstract class AbstractModelAction<T>
implements ModelAction {
    public static final List<ModelReference<?>> EMPTY_MODEL_REF_LIST = Collections.emptyList();
    protected final ModelReference<T> subject;
    protected final ModelRuleDescriptor descriptor;
    protected final List<? extends ModelReference<?>> inputs;

    protected AbstractModelAction(ModelReference<T> subject, ModelRuleDescriptor descriptor, ModelReference<?> ... inputs) {
        this(subject, descriptor, inputs == null ? EMPTY_MODEL_REF_LIST : Arrays.asList(inputs));
    }

    protected AbstractModelAction(ModelReference<T> subject, ModelRuleDescriptor descriptor, List<? extends ModelReference<?>> inputs) {
        this.subject = (ModelReference)Preconditions.checkNotNull(subject, (Object)"subject");
        this.descriptor = (ModelRuleDescriptor)Preconditions.checkNotNull((Object)descriptor, (Object)"descriptor");
        Preconditions.checkNotNull(inputs, (Object)"inputs");
        this.inputs = inputs.isEmpty() ? EMPTY_MODEL_REF_LIST : inputs;
    }

    public final ModelReference<T> getSubject() {
        return this.subject;
    }

    @Override
    public final ModelRuleDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public final List<? extends ModelReference<?>> getInputs() {
        return this.inputs;
    }
}

